/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.OzonePBHelper;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.proxy.SCMContainerLocationFailoverProxyProvider;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolClientSideTranslatorPB
implements StorageContainerLocationProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final StorageContainerLocationProtocolPB rpcProxy;
    private final SCMContainerLocationFailoverProxyProvider fpp;

    public StorageContainerLocationProtocolClientSideTranslatorPB(SCMContainerLocationFailoverProxyProvider proxyProvider) {
        Preconditions.checkNotNull((Object)proxyProvider);
        this.fpp = proxyProvider;
        this.rpcProxy = (StorageContainerLocationProtocolPB)RetryProxy.create(StorageContainerLocationProtocolPB.class, (FailoverProxyProvider)this.fpp, (RetryPolicy)this.fpp.getRetryPolicy());
    }

    private StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRequest(StorageContainerLocationProtocolProtos.Type type, Consumer<StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.Builder> builderConsumer) throws IOException {
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response;
        try {
            StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.Builder builder = StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.newBuilder().setCmdType(type).setVersion(1).setTraceID(TracingUtil.exportCurrentSpan());
            builderConsumer.accept(builder);
            StorageContainerLocationProtocolProtos.ScmContainerLocationRequest wrapper = builder.build();
            response = this.submitRpcRequest(wrapper);
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
        return response;
    }

    private StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRpcRequest(StorageContainerLocationProtocolProtos.ScmContainerLocationRequest wrapper) throws ServiceException {
        if (!ADMIN_COMMAND_TYPE.contains(wrapper.getCmdType())) {
            return this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
        }
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = null;
        for (StorageContainerLocationProtocolPB proxy : this.fpp.getProxies()) {
            response = proxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
        }
        return response;
    }

    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        StorageContainerLocationProtocolProtos.ContainerRequestProto request = StorageContainerLocationProtocolProtos.ContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setReplicationFactor(factor).setReplicationType(type).setOwner(owner).build();
        StorageContainerLocationProtocolProtos.ContainerResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.AllocateContainer, builder -> builder.setContainerRequest(request)).getContainerResponse();
        if (response.getErrorCode() != StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success) {
            throw new IOException(response.hasErrorMessage() ? response.getErrorMessage() : "Allocate container failed.");
        }
        return ContainerWithPipeline.fromProtobuf((HddsProtos.ContainerWithPipeline)response.getContainerWithPipeline());
    }

    public ContainerInfo getContainer(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerRequestProto request = StorageContainerLocationProtocolProtos.GetContainerRequestProto.newBuilder().setContainerID(containerID).setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainer, builder -> builder.setGetContainerRequest(request));
        return ContainerInfo.fromProtobuf((HddsProtos.ContainerInfoProto)response.getGetContainerResponse().getContainerInfo());
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request = StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerWithPipeline, builder -> builder.setGetContainerWithPipelineRequest(request));
        return ContainerWithPipeline.fromProtobuf((HddsProtos.ContainerWithPipeline)response.getGetContainerWithPipelineResponse().getContainerWithPipeline());
    }

    public List<ContainerWithPipeline> getContainerWithPipelineBatch(List<Long> containerIDs) throws IOException {
        for (Long containerID : containerIDs) {
            Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        }
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchRequestProto request = StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).addAllContainerIDs(containerIDs).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerWithPipelineBatch, builder -> builder.setGetContainerWithPipelineBatchRequest(request));
        List protoCps = response.getGetContainerWithPipelineBatchResponse().getContainerWithPipelinesList();
        ArrayList<ContainerWithPipeline> cps = new ArrayList<ContainerWithPipeline>();
        for (HddsProtos.ContainerWithPipeline cp : protoCps) {
            cps.add(ContainerWithPipeline.fromProtobuf((HddsProtos.ContainerWithPipeline)cp));
        }
        return cps;
    }

    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> containerIDs) {
        for (Long containerID : containerIDs) {
            Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        }
        StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchRequestProto request = StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).addAllContainerIDs(containerIDs).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = null;
        ArrayList<ContainerWithPipeline> cps = new ArrayList<ContainerWithPipeline>();
        try {
            response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetExistContainerWithPipelinesInBatch, builder -> builder.setGetExistContainerWithPipelinesInBatchRequest(request));
        }
        catch (IOException ex) {
            return cps;
        }
        List protoCps = response.getGetExistContainerWithPipelinesInBatchResponse().getContainerWithPipelinesList();
        for (HddsProtos.ContainerWithPipeline cp : protoCps) {
            try {
                cps.add(ContainerWithPipeline.fromProtobuf((HddsProtos.ContainerWithPipeline)cp));
            }
            catch (IOException iOException) {}
        }
        return cps;
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        return this.listContainer(startContainerID, count, null);
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        Preconditions.checkState((startContainerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        Preconditions.checkState((count > 0 ? 1 : 0) != 0, (Object)"Container count must be greater than 0.");
        StorageContainerLocationProtocolProtos.SCMListContainerRequestProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerRequestProto.newBuilder();
        builder.setStartContainerID(startContainerID);
        builder.setCount(count);
        builder.setTraceID(TracingUtil.exportCurrentSpan());
        if (state != null) {
            builder.setState(state);
        }
        StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request = builder.build();
        StorageContainerLocationProtocolProtos.SCMListContainerResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ListContainer, builder1 -> builder1.setScmListContainerRequest(request)).getScmListContainerResponse();
        ArrayList<ContainerInfo> containerList = new ArrayList<ContainerInfo>();
        for (HddsProtos.ContainerInfoProto containerInfoProto : response.getContainersList()) {
            containerList.add(ContainerInfo.fromProtobuf((HddsProtos.ContainerInfoProto)containerInfoProto));
        }
        return containerList;
    }

    public void deleteContainer(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request = StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.DeleteContainer, builder -> builder.setScmDeleteContainerRequest(request));
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState nodeState, HddsProtos.QueryScope queryScope, String poolName, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.NodeQueryRequestProto.Builder builder = StorageContainerLocationProtocolProtos.NodeQueryRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setScope(queryScope).setPoolName(poolName);
        if (opState != null) {
            builder.setOpState(opState);
        }
        if (nodeState != null) {
            builder.setState(nodeState);
        }
        StorageContainerLocationProtocolProtos.NodeQueryRequestProto request = builder.build();
        StorageContainerLocationProtocolProtos.NodeQueryResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.QueryNode, builder1 -> builder1.setNodeQueryRequest(request)).getNodeQueryResponse();
        return response.getDatanodesList();
    }

    public List<DatanodeAdminError> decommissionNodes(List<String> nodes) throws IOException {
        Preconditions.checkNotNull(nodes);
        StorageContainerLocationProtocolProtos.DecommissionNodesRequestProto request = StorageContainerLocationProtocolProtos.DecommissionNodesRequestProto.newBuilder().addAllHosts(nodes).build();
        StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.DecommissionNodes, builder -> builder.setDecommissionNodesRequest(request)).getDecommissionNodesResponse();
        ArrayList<DatanodeAdminError> errors = new ArrayList<DatanodeAdminError>();
        for (StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto e : response.getFailedHostsList()) {
            errors.add(new DatanodeAdminError(e.getHost(), e.getError()));
        }
        return errors;
    }

    public List<DatanodeAdminError> recommissionNodes(List<String> nodes) throws IOException {
        Preconditions.checkNotNull(nodes);
        StorageContainerLocationProtocolProtos.RecommissionNodesRequestProto request = StorageContainerLocationProtocolProtos.RecommissionNodesRequestProto.newBuilder().addAllHosts(nodes).build();
        StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.RecommissionNodes, builder -> builder.setRecommissionNodesRequest(request)).getRecommissionNodesResponse();
        ArrayList<DatanodeAdminError> errors = new ArrayList<DatanodeAdminError>();
        for (StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto e : response.getFailedHostsList()) {
            errors.add(new DatanodeAdminError(e.getHost(), e.getError()));
        }
        return errors;
    }

    public List<DatanodeAdminError> startMaintenanceNodes(List<String> nodes, int endInHours) throws IOException {
        Preconditions.checkNotNull(nodes);
        StorageContainerLocationProtocolProtos.StartMaintenanceNodesRequestProto request = StorageContainerLocationProtocolProtos.StartMaintenanceNodesRequestProto.newBuilder().addAllHosts(nodes).setEndInHours((long)endInHours).build();
        StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.StartMaintenanceNodes, builder -> builder.setStartMaintenanceNodesRequest(request)).getStartMaintenanceNodesResponse();
        ArrayList<DatanodeAdminError> errors = new ArrayList<DatanodeAdminError>();
        for (StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto e : response.getFailedHostsList()) {
            errors.add(new DatanodeAdminError(e.getHost(), e.getError()));
        }
        return errors;
    }

    public void closeContainer(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto request = StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.CloseContainer, builder -> builder.setScmCloseContainerRequest(request));
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        StorageContainerLocationProtocolProtos.PipelineRequestProto request = StorageContainerLocationProtocolProtos.PipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setNodePool(nodePool).setReplicationFactor(factor).setReplicationType(replicationType).build();
        StorageContainerLocationProtocolProtos.PipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.AllocatePipeline, builder -> builder.setPipelineRequest(request)).getPipelineResponse();
        if (response.getErrorCode() == StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.success) {
            Preconditions.checkState((boolean)response.hasPipeline(), (Object)"With success, must come a pipeline");
            return Pipeline.getFromProtobuf((HddsProtos.Pipeline)response.getPipeline());
        }
        String errorMessage = String.format("create replication pipeline failed. code : %s Message: %s", response.getErrorCode(), response.hasErrorMessage() ? response.getErrorMessage() : "");
        throw new IOException(errorMessage);
    }

    public List<Pipeline> listPipelines() throws IOException {
        StorageContainerLocationProtocolProtos.ListPipelineRequestProto request = StorageContainerLocationProtocolProtos.ListPipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.ListPipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ListPipelines, builder -> builder.setListPipelineRequest(request)).getListPipelineResponse();
        ArrayList<Pipeline> list = new ArrayList<Pipeline>();
        for (HddsProtos.Pipeline pipeline : response.getPipelinesList()) {
            Pipeline fromProtobuf = Pipeline.getFromProtobuf((HddsProtos.Pipeline)pipeline);
            list.add(fromProtobuf);
        }
        return list;
    }

    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.GetPipelineRequestProto request = StorageContainerLocationProtocolProtos.GetPipelineRequestProto.newBuilder().setPipelineID(pipelineID).setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.GetPipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetPipeline, builder -> builder.setGetPipelineRequest(request)).getGetPipelineResponse();
        return Pipeline.getFromProtobuf((HddsProtos.Pipeline)response.getPipeline());
    }

    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto request = StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.ActivatePipeline, builder -> builder.setActivatePipelineRequest(request));
    }

    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto request = StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.DeactivatePipeline, builder -> builder.setDeactivatePipelineRequest(request));
    }

    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request = StorageContainerLocationProtocolProtos.ClosePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.ClosePipeline, builder -> builder.setClosePipelineRequest(request));
    }

    public ScmInfo getScmInfo() throws IOException {
        HddsProtos.GetScmInfoRequestProto request = HddsProtos.GetScmInfoRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
        HddsProtos.GetScmInfoResponseProto resp = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetScmInfo, builder -> builder.setGetScmInfoRequest(request)).getGetScmInfoResponse();
        ScmInfo.Builder builder2 = new ScmInfo.Builder().setClusterId(resp.getClusterId()).setScmId(resp.getScmId()).setRatisPeerRoles(resp.getPeerRolesList());
        return builder2.build();
    }

    public boolean inSafeMode() throws IOException {
        StorageContainerLocationProtocolProtos.InSafeModeRequestProto request = StorageContainerLocationProtocolProtos.InSafeModeRequestProto.getDefaultInstance();
        return this.submitRequest(StorageContainerLocationProtocolProtos.Type.InSafeMode, builder -> builder.setInSafeModeRequest(request)).getInSafeModeResponse().getInSafeMode();
    }

    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException {
        StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesRequestProto request = StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetSafeModeRuleStatuses, builder -> builder.setGetSafeModeRuleStatusesRequest(request)).getGetSafeModeRuleStatusesResponse();
        HashMap<String, Pair<Boolean, String>> map = new HashMap<String, Pair<Boolean, String>>();
        for (StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto statusProto : response.getSafeModeRuleStatusesProtoList()) {
            map.put(statusProto.getRuleName(), (Pair<Boolean, String>)Pair.of((Object)statusProto.getValidate(), (Object)statusProto.getStatusText()));
        }
        return map;
    }

    public boolean forceExitSafeMode() throws IOException {
        StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto request = StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto resp = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ForceExitSafeMode, builder -> builder.setForceExitSafeModeRequest(request)).getForceExitSafeModeResponse();
        return resp.getExitedSafeMode();
    }

    public void startReplicationManager() throws IOException {
        StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto request = StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto.getDefaultInstance();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.StartReplicationManager, builder -> builder.setStartReplicationManagerRequest(request));
    }

    public void stopReplicationManager() throws IOException {
        StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto request = StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto.getDefaultInstance();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.StopReplicationManager, builder -> builder.setStopReplicationManagerRequest(request));
    }

    public boolean getReplicationManagerStatus() throws IOException {
        StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto request = StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetReplicationManagerStatus, builder -> builder.setSeplicationManagerStatusRequest(request)).getReplicationManagerStatusResponse();
        return response.getIsRunning();
    }

    public boolean startContainerBalancer(Optional<Double> threshold, Optional<Integer> idleiterations, Optional<Double> maxDatanodesRatioToInvolvePerIteration, Optional<Long> maxSizeToMovePerIterationInGB, Optional<Long> maxSizeEnteringTargetInGB, Optional<Long> maxSizeLeavingSourceInGB) throws IOException {
        StorageContainerLocationProtocolProtos.StartContainerBalancerRequestProto.Builder builder = StorageContainerLocationProtocolProtos.StartContainerBalancerRequestProto.newBuilder();
        builder.setTraceID(TracingUtil.exportCurrentSpan());
        if (threshold.isPresent()) {
            double tsd = threshold.get();
            Preconditions.checkState((tsd >= 0.0 && tsd < 1.0 ? 1 : 0) != 0, (Object)"threshold should to be specified in range [0.0, 1.0).");
            builder.setThreshold(tsd);
        }
        if (maxSizeToMovePerIterationInGB.isPresent()) {
            long mstm = maxSizeToMovePerIterationInGB.get();
            Preconditions.checkState((mstm > 0L ? 1 : 0) != 0, (Object)"maxSizeToMovePerIterationInGB must be positive.");
            builder.setMaxSizeToMovePerIterationInGB(mstm);
        }
        if (maxDatanodesRatioToInvolvePerIteration.isPresent()) {
            double mdti = maxDatanodesRatioToInvolvePerIteration.get();
            Preconditions.checkState((mdti >= 0.0 ? 1 : 0) != 0, (Object)"maxDatanodesRatioToInvolvePerIteration must be greater than equal to zero.");
            Preconditions.checkState((mdti <= 1.0 ? 1 : 0) != 0, (Object)"maxDatanodesRatioToInvolvePerIteration must be lesser than equal to one.");
            builder.setMaxDatanodesRatioToInvolvePerIteration(mdti);
        }
        if (idleiterations.isPresent()) {
            int idi = idleiterations.get();
            Preconditions.checkState((idi > 0 || idi == -1 ? 1 : 0) != 0, (Object)"idleiterations must be positive or -1(infinitly run container balancer).");
            builder.setIdleiterations(idi);
        }
        if (maxSizeEnteringTargetInGB.isPresent()) {
            long mset = maxSizeEnteringTargetInGB.get();
            Preconditions.checkState((mset > 0L ? 1 : 0) != 0, (Object)"maxSizeEnteringTargetInGB must be positive.");
            builder.setMaxSizeEnteringTargetInGB(mset);
        }
        if (maxSizeLeavingSourceInGB.isPresent()) {
            long msls = maxSizeLeavingSourceInGB.get();
            Preconditions.checkState((msls > 0L ? 1 : 0) != 0, (Object)"maxSizeLeavingSourceInGB must be positive.");
            builder.setMaxSizeLeavingSourceInGB(msls);
        }
        StorageContainerLocationProtocolProtos.StartContainerBalancerRequestProto request = builder.build();
        StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.StartContainerBalancer, builder1 -> builder1.setStartContainerBalancerRequest(request)).getStartContainerBalancerResponse();
        return response.getStart();
    }

    public void stopContainerBalancer() throws IOException {
        StorageContainerLocationProtocolProtos.StopContainerBalancerRequestProto request = StorageContainerLocationProtocolProtos.StopContainerBalancerRequestProto.getDefaultInstance();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.StopContainerBalancer, builder -> builder.setStopContainerBalancerRequest(request));
    }

    public boolean getContainerBalancerStatus() throws IOException {
        StorageContainerLocationProtocolProtos.ContainerBalancerStatusRequestProto request = StorageContainerLocationProtocolProtos.ContainerBalancerStatusRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ContainerBalancerStatusResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerBalancerStatus, builder -> builder.setContainerBalancerStatusRequest(request)).getContainerBalancerStatusResponse();
        return response.getIsRunning();
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String ipaddress, String uuid) throws IOException {
        StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto request = StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto.newBuilder().setIpaddress(ipaddress).setUuid(uuid).build();
        StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.DatanodeUsageInfo, builder -> builder.setDatanodeUsageInfoRequest(request)).getDatanodeUsageInfoResponse();
        return response.getInfoList();
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean mostUsed, int count) throws IOException {
        StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto request = StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto.newBuilder().setMostUsed(mostUsed).setCount(count).build();
        StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.DatanodeUsageInfo, builder -> builder.setDatanodeUsageInfoRequest(request)).getDatanodeUsageInfoResponse();
        return response.getInfoList();
    }

    public UpgradeFinalizer.StatusAndMessages finalizeScmUpgrade(String upgradeClientID) throws IOException {
        StorageContainerLocationProtocolProtos.FinalizeScmUpgradeRequestProto req = StorageContainerLocationProtocolProtos.FinalizeScmUpgradeRequestProto.newBuilder().setUpgradeClientId(upgradeClientID).build();
        StorageContainerLocationProtocolProtos.FinalizeScmUpgradeResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.FinalizeScmUpgrade, builder -> builder.setFinalizeScmUpgradeRequest(req)).getFinalizeScmUpgradeResponse();
        HddsProtos.UpgradeFinalizationStatus status = response.getStatus();
        return new UpgradeFinalizer.StatusAndMessages(UpgradeFinalizer.Status.valueOf((String)status.getStatus().name()), (Collection)status.getMessagesList());
    }

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean force, boolean readonly) throws IOException {
        StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressRequestProto req = StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressRequestProto.newBuilder().setUpgradeClientId(upgradeClientID).setTakeover(force).setReadonly(readonly).build();
        StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.QueryUpgradeFinalizationProgress, builder -> builder.setQueryUpgradeFinalizationProgressRequest(req)).getQueryUpgradeFinalizationProgressResponse();
        HddsProtos.UpgradeFinalizationStatus status = response.getStatus();
        return new UpgradeFinalizer.StatusAndMessages(UpgradeFinalizer.Status.valueOf((String)status.getStatus().name()), (Collection)status.getMessagesList());
    }

    public Token<?> getContainerToken(ContainerID containerID) throws IOException {
        StorageContainerLocationProtocolProtos.GetContainerTokenRequestProto request = StorageContainerLocationProtocolProtos.GetContainerTokenRequestProto.newBuilder().setContainerID(containerID.getProtobuf()).build();
        StorageContainerLocationProtocolProtos.GetContainerTokenResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerToken, builder -> builder.setContainerTokenRequest(request)).getContainerTokenResponse();
        return OzonePBHelper.tokenFromProto(response.getToken());
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }
}

