/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.AddSCMRequest;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.proxy.SCMBlockLocationFailoverProxyProvider;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;

@InterfaceAudience.Private
public final class ScmBlockLocationProtocolClientSideTranslatorPB
implements ScmBlockLocationProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final ScmBlockLocationProtocolPB rpcProxy;
    private SCMBlockLocationFailoverProxyProvider failoverProxyProvider;

    public ScmBlockLocationProtocolClientSideTranslatorPB(SCMBlockLocationFailoverProxyProvider proxyProvider) {
        Preconditions.checkState((proxyProvider != null ? 1 : 0) != 0);
        this.failoverProxyProvider = proxyProvider;
        this.rpcProxy = (ScmBlockLocationProtocolPB)RetryProxy.create(ScmBlockLocationProtocolPB.class, (FailoverProxyProvider)this.failoverProxyProvider, (RetryPolicy)this.failoverProxyProvider.getSCMBlockLocationRetryPolicy(null));
    }

    private ScmBlockLocationProtocolProtos.SCMBlockLocationRequest.Builder createSCMBlockRequest(ScmBlockLocationProtocolProtos.Type cmdType) {
        return ScmBlockLocationProtocolProtos.SCMBlockLocationRequest.newBuilder().setCmdType(cmdType).setVersion(1).setTraceID(TracingUtil.exportCurrentSpan());
    }

    private ScmBlockLocationProtocolProtos.SCMBlockLocationResponse submitRequest(ScmBlockLocationProtocolProtos.SCMBlockLocationRequest req) throws IOException {
        try {
            ScmBlockLocationProtocolProtos.SCMBlockLocationResponse response = this.rpcProxy.send(NULL_RPC_CONTROLLER, req);
            return response;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    private ScmBlockLocationProtocolProtos.SCMBlockLocationResponse handleError(ScmBlockLocationProtocolProtos.SCMBlockLocationResponse resp) throws SCMException {
        if (resp.getStatus() != ScmBlockLocationProtocolProtos.Status.OK) {
            throw new SCMException(resp.getMessage(), SCMException.ResultCodes.values()[resp.getStatus().ordinal()]);
        }
        return resp;
    }

    @Override
    public List<AllocatedBlock> allocateBlock(long size, int num, ReplicationConfig replicationConfig, String owner, ExcludeList excludeList) throws IOException {
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"block size must be greater than 0");
        ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto.Builder requestBuilder = ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto.newBuilder().setSize(size).setNumBlocks(num).setType(replicationConfig.getReplicationType()).setOwner(owner).setExcludeList(excludeList.getProtoBuf());
        switch (replicationConfig.getReplicationType()) {
            case STAND_ALONE: {
                requestBuilder.setFactor(((StandaloneReplicationConfig)replicationConfig).getReplicationFactor());
                break;
            }
            case RATIS: {
                requestBuilder.setFactor(((RatisReplicationConfig)replicationConfig).getReplicationFactor());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported replication type " + replicationConfig.getReplicationType());
            }
        }
        ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto request = requestBuilder.build();
        ScmBlockLocationProtocolProtos.SCMBlockLocationRequest wrapper = this.createSCMBlockRequest(ScmBlockLocationProtocolProtos.Type.AllocateScmBlock).setAllocateScmBlockRequest(request).build();
        ScmBlockLocationProtocolProtos.SCMBlockLocationResponse wrappedResponse = this.handleError(this.submitRequest(wrapper));
        ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto response = wrappedResponse.getAllocateScmBlockResponse();
        ArrayList<AllocatedBlock> blocks = new ArrayList<AllocatedBlock>(response.getBlocksCount());
        for (ScmBlockLocationProtocolProtos.AllocateBlockResponse resp : response.getBlocksList()) {
            AllocatedBlock.Builder builder = new AllocatedBlock.Builder().setContainerBlockID(ContainerBlockID.getFromProtobuf((HddsProtos.ContainerBlockID)resp.getContainerBlockID())).setPipeline(Pipeline.getFromProtobuf((HddsProtos.Pipeline)resp.getPipeline()));
            blocks.add(builder.build());
        }
        return blocks;
    }

    @Override
    public List<DeleteBlockGroupResult> deleteKeyBlocks(List<BlockGroup> keyBlocksInfoList) throws IOException {
        List keyBlocksProto = keyBlocksInfoList.stream().map(BlockGroup::getProto).collect(Collectors.toList());
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto request = ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto.newBuilder().addAllKeyBlocks(keyBlocksProto).build();
        ScmBlockLocationProtocolProtos.SCMBlockLocationRequest wrapper = this.createSCMBlockRequest(ScmBlockLocationProtocolProtos.Type.DeleteScmKeyBlocks).setDeleteScmKeyBlocksRequest(request).build();
        ScmBlockLocationProtocolProtos.SCMBlockLocationResponse wrappedResponse = this.handleError(this.submitRequest(wrapper));
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto resp = wrappedResponse.getDeleteScmKeyBlocksResponse();
        ArrayList<DeleteBlockGroupResult> results = new ArrayList<DeleteBlockGroupResult>(resp.getResultsCount());
        results.addAll(resp.getResultsList().stream().map(result -> new DeleteBlockGroupResult(result.getObjectKey(), DeleteBlockGroupResult.convertBlockResultProto(result.getBlockResultsList()))).collect(Collectors.toList()));
        return results;
    }

    @Override
    public ScmInfo getScmInfo() throws IOException {
        HddsProtos.GetScmInfoRequestProto request = HddsProtos.GetScmInfoRequestProto.getDefaultInstance();
        ScmBlockLocationProtocolProtos.SCMBlockLocationRequest wrapper = this.createSCMBlockRequest(ScmBlockLocationProtocolProtos.Type.GetScmInfo).setGetScmInfoRequest(request).build();
        ScmBlockLocationProtocolProtos.SCMBlockLocationResponse wrappedResponse = this.handleError(this.submitRequest(wrapper));
        HddsProtos.GetScmInfoResponseProto resp = wrappedResponse.getGetScmInfoResponse();
        ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(resp.getClusterId()).setScmId(resp.getScmId());
        return builder.build();
    }

    @Override
    public boolean addSCM(AddSCMRequest request) throws IOException {
        HddsProtos.AddScmRequestProto requestProto = request.getProtobuf();
        ScmBlockLocationProtocolProtos.SCMBlockLocationRequest wrapper = this.createSCMBlockRequest(ScmBlockLocationProtocolProtos.Type.AddScm).setAddScmRequestProto(requestProto).build();
        ScmBlockLocationProtocolProtos.SCMBlockLocationResponse wrappedResponse = this.handleError(this.submitRequest(wrapper));
        HddsProtos.AddScmResponseProto resp = wrappedResponse.getAddScmResponse();
        return resp.getSuccess();
    }

    @Override
    public List<DatanodeDetails> sortDatanodes(List<String> nodes, String clientMachine) throws IOException {
        ScmBlockLocationProtocolProtos.SortDatanodesRequestProto request = ScmBlockLocationProtocolProtos.SortDatanodesRequestProto.newBuilder().addAllNodeNetworkName(nodes).setClient(clientMachine).build();
        ScmBlockLocationProtocolProtos.SCMBlockLocationRequest wrapper = this.createSCMBlockRequest(ScmBlockLocationProtocolProtos.Type.SortDatanodes).setSortDatanodesRequest(request).build();
        ScmBlockLocationProtocolProtos.SCMBlockLocationResponse wrappedResponse = this.handleError(this.submitRequest(wrapper));
        ScmBlockLocationProtocolProtos.SortDatanodesResponseProto resp = wrappedResponse.getSortDatanodesResponse();
        ArrayList<DatanodeDetails> results = new ArrayList<DatanodeDetails>(resp.getNodeCount());
        results.addAll(resp.getNodeList().stream().map(node -> DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node)).collect(Collectors.toList()));
        return results;
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void close() throws IOException {
        this.failoverProxyProvider.close();
    }
}

