/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.protobuf.ByteString;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public final class OzonePBHelper {
    private static final ConcurrentHashMap<Object, ByteString> FIXED_BYTESTRING_CACHE = new ConcurrentHashMap();

    private OzonePBHelper() {
    }

    public static ByteString getFixedByteString(Text key) {
        return FIXED_BYTESTRING_CACHE.computeIfAbsent(key, k -> ByteString.copyFromUtf8((String)k.toString()));
    }

    public static ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    public static Token<? extends TokenIdentifier> tokenFromProto(HddsProtos.TokenProto tokenProto) {
        return new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
    }

    public static HddsProtos.TokenProto protoFromToken(Token<?> token) {
        HddsProtos.TokenProto.Builder builder = HddsProtos.TokenProto.newBuilder().setIdentifier(OzonePBHelper.getByteString(token.getIdentifier())).setPassword(OzonePBHelper.getByteString(token.getPassword())).setKindBytes(OzonePBHelper.getFixedByteString(token.getKind())).setServiceBytes(OzonePBHelper.getFixedByteString(token.getService()));
        return builder.build();
    }
}

