/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.ratis.util.Preconditions;

public class MoveDataNodePair {
    private final DatanodeDetails src;
    private final DatanodeDetails tgt;

    public MoveDataNodePair(DatanodeDetails src, DatanodeDetails tgt) {
        this.src = src;
        this.tgt = tgt;
    }

    public DatanodeDetails getTgt() {
        return this.tgt;
    }

    public DatanodeDetails getSrc() {
        return this.src;
    }

    public HddsProtos.MoveDataNodePairProto getProtobufMessage(int clientVersion) throws IOException {
        HddsProtos.MoveDataNodePairProto.Builder builder = HddsProtos.MoveDataNodePairProto.newBuilder().setSrc(this.src.toProto(clientVersion)).setTgt(this.tgt.toProto(clientVersion));
        return builder.build();
    }

    public static MoveDataNodePair getFromProtobuf(HddsProtos.MoveDataNodePairProto mdnpp) {
        Preconditions.assertNotNull((Object)mdnpp, (String)"MoveDataNodePair is null");
        DatanodeDetails src = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)mdnpp.getSrc());
        DatanodeDetails tgt = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)mdnpp.getTgt());
        return new MoveDataNodePair(src, tgt);
    }
}

