/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocolPB;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.scm.proxy.SCMSecurityProtocolFailoverProxyProvider;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;

public class SCMSecurityProtocolClientSideTranslatorPB
implements SCMSecurityProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final SCMSecurityProtocolPB rpcProxy;
    private SCMSecurityProtocolFailoverProxyProvider failoverProxyProvider;

    public SCMSecurityProtocolClientSideTranslatorPB(SCMSecurityProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    public SCMSecurityProtocolClientSideTranslatorPB(SCMSecurityProtocolFailoverProxyProvider proxyProvider) {
        Preconditions.checkState((proxyProvider != null ? 1 : 0) != 0);
        this.failoverProxyProvider = proxyProvider;
        this.rpcProxy = (SCMSecurityProtocolPB)RetryProxy.create(SCMSecurityProtocolPB.class, (FailoverProxyProvider)this.failoverProxyProvider, (RetryPolicy)this.failoverProxyProvider.getRetryPolicy());
    }

    private SCMSecurityProtocolProtos.SCMSecurityResponse submitRequest(SCMSecurityProtocolProtos.Type type, Consumer<SCMSecurityProtocolProtos.SCMSecurityRequest.Builder> builderConsumer) throws IOException {
        SCMSecurityProtocolProtos.SCMSecurityResponse response;
        try {
            SCMSecurityProtocolProtos.SCMSecurityRequest.Builder builder = SCMSecurityProtocolProtos.SCMSecurityRequest.newBuilder().setCmdType(type).setTraceID(TracingUtil.exportCurrentSpan());
            builderConsumer.accept(builder);
            SCMSecurityProtocolProtos.SCMSecurityRequest wrapper = builder.build();
            response = this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
            this.handleError(response);
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
        return response;
    }

    private SCMSecurityProtocolProtos.SCMSecurityResponse handleError(SCMSecurityProtocolProtos.SCMSecurityResponse resp) throws SCMSecurityException {
        if (resp.getStatus() != SCMSecurityProtocolProtos.Status.OK) {
            throw new SCMSecurityException(resp.getMessage(), SCMSecurityException.ErrorCode.values()[resp.getStatus().ordinal()]);
        }
        return resp;
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public String getDataNodeCertificate(HddsProtos.DatanodeDetailsProto dataNodeDetails, String certSignReq) throws IOException {
        return this.getDataNodeCertificateChain(dataNodeDetails, certSignReq).getX509Certificate();
    }

    @Override
    public String getOMCertificate(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        return this.getOMCertChain(omDetails, certSignReq).getX509Certificate();
    }

    @Override
    public String getSCMCertificate(HddsProtos.ScmNodeDetailsProto scmNodeDetails, String certSignReq) throws IOException {
        return this.getSCMCertChain(scmNodeDetails, certSignReq).getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getSCMCertChain(HddsProtos.ScmNodeDetailsProto scmNodeDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetSCMCertRequestProto request = SCMSecurityProtocolProtos.SCMGetSCMCertRequestProto.newBuilder().setCSR(certSignReq).setScmDetails(scmNodeDetails).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetSCMCertificate, builder -> builder.setGetSCMCertificateRequest(request)).getGetCertResponseProto();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getOMCertChain(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetOMCertRequestProto request = SCMSecurityProtocolProtos.SCMGetOMCertRequestProto.newBuilder().setCSR(certSignReq).setOmDetails(omDetails).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetOMCertificate, builder -> builder.setGetOMCertRequest(request)).getGetCertResponseProto();
    }

    @Override
    public String getCertificate(String certSerialId) throws IOException {
        SCMSecurityProtocolProtos.SCMGetCertificateRequestProto request = SCMSecurityProtocolProtos.SCMGetCertificateRequestProto.newBuilder().setCertSerialId(certSerialId).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetCertificate, builder -> builder.setGetCertificateRequest(request)).getGetCertResponseProto().getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getDataNodeCertificateChain(HddsProtos.DatanodeDetailsProto dnDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto request = SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto.newBuilder().setCSR(certSignReq).setDatanodeDetails(dnDetails).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetDataNodeCertificate, builder -> builder.setGetDataNodeCertRequest(request)).getGetCertResponseProto();
    }

    @Override
    public String getCACertificate() throws IOException {
        return this.getCACert().getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCACert() throws IOException {
        SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetCACertificate, builder -> builder.setGetCACertificateRequest(protoIns)).getGetCertResponseProto();
    }

    @Override
    public List<String> listCertificate(HddsProtos.NodeType role, long startSerialId, int count, boolean isRevoked) throws IOException {
        SCMSecurityProtocolProtos.SCMListCertificateRequestProto protoIns = SCMSecurityProtocolProtos.SCMListCertificateRequestProto.newBuilder().setRole(role).setStartCertId(startSerialId).setCount(count).setIsRevoked(isRevoked).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.ListCertificate, builder -> builder.setListCertificateRequest(protoIns)).getListCertificateResponseProto().getCertificatesList();
    }

    @Override
    public String getRootCACertificate() throws IOException {
        SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetRootCACertificate, builder -> builder.setGetCACertificateRequest(protoIns)).getGetCertResponseProto().getX509RootCACertificate();
    }

    @Override
    public List<String> listCACertificate() throws IOException {
        SCMSecurityProtocolProtos.SCMListCACertificateRequestProto proto = SCMSecurityProtocolProtos.SCMListCACertificateRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.ListCACertificate, builder -> builder.setListCACertificateRequestProto(proto)).getListCertificateResponseProto().getCertificatesList();
    }

    @Override
    public List<CRLInfo> getCrls(List<Long> crlIds) throws IOException {
        SCMSecurityProtocolProtos.SCMGetCrlsRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetCrlsRequestProto.newBuilder().addAllCrlId(crlIds).build();
        List crlInfoProtoList = this.submitRequest(SCMSecurityProtocolProtos.Type.GetCrls, builder -> builder.setGetCrlsRequest(protoIns)).getGetCrlsResponseProto().getCrlInfosList();
        ArrayList<CRLInfo> result = new ArrayList<CRLInfo>();
        for (HddsProtos.CRLInfoProto crlProto : crlInfoProtoList) {
            try {
                CRLInfo crlInfo = CRLInfo.fromProtobuf(crlProto);
                result.add(crlInfo);
            }
            catch (CRLException | CertificateException e) {
                throw new SCMSecurityException("Fail to parse CRL info", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public long getLatestCrlId() throws IOException {
        SCMSecurityProtocolProtos.SCMGetLatestCrlIdRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetLatestCrlIdRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetLatestCrlId, builder -> builder.setGetLatestCrlIdRequest(protoIns)).getGetLatestCrlIdResponseProto().getCrlId();
    }

    @Override
    public long revokeCertificates(List<String> certIds, int reason, long revocationTime) throws IOException {
        SCMSecurityProtocolProtos.SCMRevokeCertificatesRequestProto req = SCMSecurityProtocolProtos.SCMRevokeCertificatesRequestProto.newBuilder().addAllCertIds(certIds).setReason(SCMSecurityProtocolProtos.SCMRevokeCertificatesRequestProto.Reason.valueOf((int)reason)).setRevokeTime(revocationTime).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.RevokeCertificates, builder -> builder.setRevokeCertificatesRequest(req)).getRevokeCertificatesResponseProto().getCrlId();
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

