/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.ratis.raft.server")
public class DatanodeRatisServerConfig {
    @Config(key="rpc.request.timeout", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="The timeout duration of the ratis write request on Ratis Server.")
    private long requestTimeOut = Duration.ofSeconds(60L).toMillis();
    @Config(key="watch.timeout", defaultValue="180s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="The timeout duration for watch request on Ratis Server. Timeout for the watch request in Ratis server to acknowledge a particular request is replayed to all servers.")
    private long watchTimeOut = Duration.ofSeconds(180L).toMillis();
    @Config(key="notification.no-leader.timeout", defaultValue="300s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="Time out duration after which StateMachine gets notified that leader has not been elected for a long time and leader changes its role to Candidate.")
    private long noLeaderTimeout = Duration.ofSeconds(300L).toMillis();
    @Config(key="rpc.slowness.timeout", defaultValue="300s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="Timeout duration after which stateMachine will be notified that follower is slow. StateMachine will close down the pipeline.")
    private long followerSlownessTimeout = Duration.ofSeconds(300L).toMillis();
    @Config(key="write.element-limit", defaultValue="1024", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS, ConfigTag.PERFORMANCE}, description="Maximum number of pending requests after which the leader starts rejecting requests from client.")
    private int leaderNumPendingRequests;
    @Config(key="delete.ratis.log.directory", defaultValue="true", type=ConfigType.BOOLEAN, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="Flag to indicate whether ratis log directory will becleaned up during pipeline remove.")
    private boolean shouldDeleteRatisLogDirectory;
    @Config(key="leaderelection.pre-vote", defaultValue="false", type=ConfigType.BOOLEAN, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="Flag to enable/disable ratis election pre-vote.")
    private boolean preVoteEnabled;

    public long getRequestTimeOut() {
        return this.requestTimeOut;
    }

    public void setRequestTimeOut(Duration duration) {
        this.requestTimeOut = duration.toMillis();
    }

    public long getWatchTimeOut() {
        return this.watchTimeOut;
    }

    public void setWatchTimeOut(Duration duration) {
        this.watchTimeOut = duration.toMillis();
    }

    public long getNoLeaderTimeout() {
        return this.noLeaderTimeout;
    }

    public void setNoLeaderTimeout(Duration duration) {
        this.noLeaderTimeout = duration.toMillis();
    }

    public long getFollowerSlownessTimeout() {
        return this.followerSlownessTimeout;
    }

    public void setFollowerSlownessTimeout(Duration duration) {
        this.followerSlownessTimeout = duration.toMillis();
    }

    public int getLeaderNumPendingRequests() {
        return this.leaderNumPendingRequests;
    }

    public void setLeaderNumPendingRequests(int leaderNumPendingRequests) {
        this.leaderNumPendingRequests = leaderNumPendingRequests;
    }

    public boolean shouldDeleteRatisLogDirectory() {
        return this.shouldDeleteRatisLogDirectory;
    }

    public void setLeaderNumPendingRequests(boolean delete) {
        this.shouldDeleteRatisLogDirectory = delete;
    }

    public boolean isPreVoteEnabled() {
        return this.preVoteEnabled;
    }

    public void setPreVote(boolean preVote) {
        this.preVoteEnabled = preVote;
    }
}

