/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpgradeFinalizationExecutor<T> {
    static final Logger LOG = LoggerFactory.getLogger(DefaultUpgradeFinalizationExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(T component, BasicUpgradeFinalizer finalizer) throws IOException {
        try {
            finalizer.emitStartingMsg();
            ((AbstractLayoutVersionManager)finalizer.getVersionManager()).setUpgradeState(UpgradeFinalizer.Status.FINALIZATION_IN_PROGRESS);
            finalizer.preFinalizeUpgrade(component);
            finalizer.finalizeUpgrade(component);
            finalizer.postFinalizeUpgrade(component);
            finalizer.emitFinishedMsg();
        }
        catch (Exception e) {
            LOG.warn("Upgrade Finalization failed with following Exception. ", (Throwable)e);
            if (((AbstractLayoutVersionManager)finalizer.getVersionManager()).needsFinalization()) {
                ((AbstractLayoutVersionManager)finalizer.getVersionManager()).setUpgradeState(UpgradeFinalizer.Status.FINALIZATION_REQUIRED);
                throw e;
            }
        }
        finally {
            finalizer.markFinalizationDone();
        }
    }
}

