/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common.utils;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public final class BufferUtils {
    private BufferUtils() {
    }

    public static ByteBuffer[] assignByteBuffers(long totalLen, long bufferCapacity) {
        Preconditions.checkArgument((totalLen > 0L ? 1 : 0) != 0, (Object)"Buffer Length should be a positive integer.");
        Preconditions.checkArgument((bufferCapacity > 0L ? 1 : 0) != 0, (Object)"Buffer Capacity should be a positive integer.");
        int numBuffers = BufferUtils.getNumberOfBins(totalLen, bufferCapacity);
        ByteBuffer[] dataBuffers = new ByteBuffer[numBuffers];
        int buffersAllocated = 0;
        for (int i = 0; i < numBuffers - 1; ++i) {
            dataBuffers[i] = ByteBuffer.allocate((int)bufferCapacity);
            buffersAllocated = (int)((long)buffersAllocated + bufferCapacity);
        }
        dataBuffers[numBuffers - 1] = ByteBuffer.allocate((int)(totalLen - (long)buffersAllocated));
        return dataBuffers;
    }

    public static List<ByteBuffer> getReadOnlyByteBuffers(List<ByteString> byteStrings) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (ByteString byteString : byteStrings) {
            buffers.add(byteString.asReadOnlyByteBuffer());
        }
        return buffers;
    }

    public static ByteBuffer[] getReadOnlyByteBuffers(ByteBuffer[] byteBuffers) {
        if (byteBuffers == null) {
            return null;
        }
        ByteBuffer[] readOnlyBuffers = new ByteBuffer[byteBuffers.length];
        for (int i = 0; i < byteBuffers.length; ++i) {
            readOnlyBuffers[i] = byteBuffers[i] == null ? null : byteBuffers[i].asReadOnlyBuffer();
        }
        return readOnlyBuffers;
    }

    public static ByteBuffer[] getReadOnlyByteBuffersArray(List<ByteString> byteStrings) {
        return BufferUtils.getReadOnlyByteBuffers(byteStrings).toArray(new ByteBuffer[0]);
    }

    public static ByteString concatByteStrings(List<ByteString> byteStrings) {
        ByteString result = ByteString.EMPTY;
        for (ByteString byteString : byteStrings) {
            result = result.concat(byteString);
        }
        return result;
    }

    public static long getBuffersLen(List<ByteString> buffers) {
        long length = 0L;
        for (ByteString buffer : buffers) {
            length += (long)buffer.size();
        }
        return length;
    }

    public static int getNumberOfBins(long numElements, long maxElementsPerBin) {
        return (int)Math.ceil((double)numElements / (double)maxElementsPerBin);
    }

    public static void clearBuffers(ByteBuffer[] byteBuffers) {
        for (ByteBuffer buffer : byteBuffers) {
            buffer.clear();
        }
    }
}

