/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateCodec {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static final Logger LOG = LoggerFactory.getLogger(CertificateCodec.class);
    private static final JcaX509CertificateConverter CERTIFICATE_CONVERTER = new JcaX509CertificateConverter();
    private final SecurityConfig securityConfig;
    private final Path location;
    private Set<PosixFilePermission> permissionSet = Stream.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE).collect(Collectors.toSet());

    public CertificateCodec(SecurityConfig config, String component) {
        this.securityConfig = config;
        this.location = this.securityConfig.getCertificateLocation(component);
    }

    public static X509Certificate getX509Certificate(X509CertificateHolder holder) throws CertificateException {
        return CERTIFICATE_CONVERTER.getCertificate(holder);
    }

    public static String getPEMEncodedString(X509CertificateHolder x509CertHolder) throws SCMSecurityException {
        try {
            return CertificateCodec.getPEMEncodedString(CertificateCodec.getX509Certificate(x509CertHolder));
        }
        catch (CertificateException exp) {
            throw new SCMSecurityException(exp);
        }
    }

    public static String getPEMEncodedString(X509Certificate certificate) throws SCMSecurityException {
        try {
            StringWriter stringWriter = new StringWriter();
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
                pemWriter.writeObject((Object)certificate);
            }
            return stringWriter.toString();
        }
        catch (IOException e) {
            LOG.error("Error in encoding certificate." + certificate.getSubjectDN().toString(), (Throwable)e);
            throw new SCMSecurityException("PEM Encoding failed for certificate." + certificate.getSubjectDN().toString(), e, SCMSecurityException.ErrorCode.PEM_ENCODE_FAILED);
        }
    }

    public static X509Certificate getX509Certificate(String pemEncodedString) throws CertificateException, IOException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        try (InputStream input = IOUtils.toInputStream((String)pemEncodedString, (Charset)StandardCharsets.UTF_8);){
            X509Certificate x509Certificate = (X509Certificate)fact.generateCertificate(input);
            return x509Certificate;
        }
    }

    public Path getLocation() {
        return this.location;
    }

    public static X509Certificate getX509Cert(String pemEncodedString) throws CertificateException, IOException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        try (InputStream input = IOUtils.toInputStream((String)pemEncodedString, (Charset)StandardCharsets.UTF_8);){
            X509Certificate x509Certificate = (X509Certificate)fact.generateCertificate(input);
            return x509Certificate;
        }
    }

    public void writeCertificate(X509CertificateHolder xCertificate) throws SCMSecurityException, IOException {
        String pem = CertificateCodec.getPEMEncodedString(xCertificate);
        this.writeCertificate(this.location.toAbsolutePath(), this.securityConfig.getCertificateFileName(), pem, false);
    }

    public void writeCertificate(X509CertificateHolder xCertificate, String fileName, boolean overwrite) throws SCMSecurityException, IOException {
        String pem = CertificateCodec.getPEMEncodedString(xCertificate);
        this.writeCertificate(this.location.toAbsolutePath(), fileName, pem, overwrite);
    }

    public synchronized void writeCertificate(Path basePath, String fileName, String pemEncodedCertificate, boolean force) throws IOException {
        File certificateFile = Paths.get(basePath.toString(), fileName).toFile();
        if (certificateFile.exists() && !force) {
            throw new SCMSecurityException("Specified certificate file already exists.Please use force option if you want to overwrite it.");
        }
        if (!basePath.toFile().exists() && !basePath.toFile().mkdirs()) {
            LOG.error("Unable to create file path. Path: {}", (Object)basePath);
            throw new IOException("Creation of the directories failed." + basePath.toString());
        }
        try (FileOutputStream file = new FileOutputStream(certificateFile);){
            IOUtils.write((String)pemEncodedCertificate, (OutputStream)file, (Charset)StandardCharsets.UTF_8);
        }
        Files.setPosixFilePermissions(certificateFile.toPath(), this.permissionSet);
    }

    public X509CertificateHolder readCertificate() throws CertificateException, IOException {
        return this.readCertificate(this.location.toAbsolutePath(), this.securityConfig.getCertificateFileName());
    }

    public synchronized X509CertificateHolder readCertificate(Path basePath, String fileName) throws IOException, CertificateException {
        File certificateFile = Paths.get(basePath.toString(), fileName).toFile();
        return this.getX509CertificateHolder(certificateFile);
    }

    private X509CertificateHolder getX509CertificateHolder(File certificateFile) throws IOException, CertificateException {
        if (!certificateFile.exists()) {
            throw new IOException("Unable to find the requested certificate. Path: " + certificateFile.toString());
        }
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        try (FileInputStream is = new FileInputStream(certificateFile);){
            X509CertificateHolder x509CertificateHolder = CertificateCodec.getCertificateHolder((X509Certificate)fact.generateCertificate(is));
            return x509CertificateHolder;
        }
    }

    public static X509CertificateHolder getCertificateHolder(X509Certificate x509cert) throws CertificateEncodingException, IOException {
        return new X509CertificateHolder(x509cert.getEncoded());
    }
}

