/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityConfig.class);
    private static volatile Provider provider;
    private final ConfigurationSource configuration;
    private final int size;
    private final String keyAlgo;
    private final String providerString;
    private final String metadatDir;
    private final String keyDir;
    private final String privateKeyFileName;
    private final String publicKeyFileName;
    private final Duration maxCertDuration;
    private final String x509SignatureAlgo;
    private final boolean blockTokenEnabled;
    private final boolean containerTokenEnabled;
    private final String certificateDir;
    private final String certificateFileName;
    private final boolean grpcTlsEnabled;
    private final Duration defaultCertDuration;
    private final boolean isSecurityEnabled;
    private final String crlName;
    private boolean grpcTlsUseTestCert;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecurityConfig(ConfigurationSource configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"Configuration cannot be null");
        this.configuration = configuration;
        this.size = this.configuration.getInt("hdds.key.len", 2048);
        this.keyAlgo = this.configuration.get("hdds.key.algo", "RSA");
        this.providerString = this.configuration.get("hdds.security.provider", "BC");
        this.metadatDir = this.configuration.get("hdds.metadata.dir", configuration.get("ozone.metadata.dirs", configuration.get("hdds.datanode.dir")));
        this.keyDir = this.configuration.get("hdds.key.dir.name", "keys");
        this.privateKeyFileName = this.configuration.get("hdds.priv.key.file.name", "private.pem");
        this.publicKeyFileName = this.configuration.get("hdds.public.key.file.name", "public.pem");
        String durationString = this.configuration.get("hdds.x509.max.duration", "P1865D");
        this.maxCertDuration = Duration.parse(durationString);
        this.x509SignatureAlgo = this.configuration.get("hdds.x509.signature.algorithm", "SHA256withRSA");
        this.certificateDir = this.configuration.get("hdds.x509.dir.name", "certs");
        this.certificateFileName = this.configuration.get("hdds.x509.file.name", "certificate.crt");
        this.blockTokenEnabled = this.configuration.getBoolean("hdds.block.token.enabled", false);
        this.containerTokenEnabled = this.configuration.getBoolean("hdds.container.token.enabled", false);
        this.grpcTlsEnabled = this.configuration.getBoolean("hdds.grpc.tls.enabled", false);
        if (this.grpcTlsEnabled) {
            this.grpcTlsUseTestCert = this.configuration.getBoolean("hdds.grpc.tls.test.cert", false);
        }
        this.isSecurityEnabled = this.configuration.getBoolean("ozone.security.enabled", false);
        String certDurationString = this.configuration.get("hdds.x509.default.duration", "P365D");
        this.defaultCertDuration = Duration.parse(certDurationString);
        if (this.maxCertDuration.compareTo(this.defaultCertDuration) < 0) {
            LOG.error("Certificate duration {} should not be greater than Maximum Certificate duration {}", (Object)this.maxCertDuration, (Object)this.defaultCertDuration);
            throw new IllegalArgumentException("Certificate duration should not be greater than maximum Certificate duration");
        }
        this.crlName = this.configuration.get("hdds.x509.CRL.name", "scm.crl");
        if (provider != null) return;
        Class<SecurityConfig> clazz = SecurityConfig.class;
        synchronized (SecurityConfig.class) {
            provider = Security.getProvider(this.providerString);
            if (provider != null) return;
            provider = this.initSecurityProvider(this.providerString);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public String getCrlName() {
        return this.crlName;
    }

    public boolean isSecurityEnabled() {
        return this.isSecurityEnabled;
    }

    public Duration getDefaultCertDuration() {
        return this.defaultCertDuration;
    }

    public String getCertificateFileName() {
        return this.certificateFileName;
    }

    public String getPublicKeyFileName() {
        return this.publicKeyFileName;
    }

    public String getPrivateKeyFileName() {
        return this.privateKeyFileName;
    }

    public Path getKeyLocation(String component) {
        Preconditions.checkNotNull((Object)this.metadatDir, (Object)"Metadata directory can't be null. Please check configs.");
        return Paths.get(this.metadatDir, component, this.keyDir);
    }

    public Path getCertificateLocation(String component) {
        Preconditions.checkNotNull((Object)this.metadatDir, (Object)"Metadata directory can't be null. Please check configs.");
        return Paths.get(this.metadatDir, component, this.certificateDir);
    }

    public int getSize() {
        return this.size;
    }

    public String getProvider() {
        return this.providerString;
    }

    public String getKeyAlgo() {
        return this.keyAlgo;
    }

    public String getSignatureAlgo() {
        return this.x509SignatureAlgo;
    }

    public ConfigurationSource getConfiguration() {
        return this.configuration;
    }

    public Duration getMaxCertificateDuration() {
        return this.maxCertDuration;
    }

    public boolean isBlockTokenEnabled() {
        return this.blockTokenEnabled;
    }

    public boolean isContainerTokenEnabled() {
        return this.containerTokenEnabled;
    }

    public boolean isGrpcTlsEnabled() {
        return this.grpcTlsEnabled;
    }

    public SslProvider getGrpcSslProvider() {
        return SslProvider.valueOf((String)this.configuration.get("hdds.grpc.tls.provider", "OPENSSL"));
    }

    public boolean useTestCert() {
        return this.grpcTlsUseTestCert;
    }

    private Provider initSecurityProvider(String providerName) {
        switch (providerName) {
            case "BC": {
                Security.addProvider((Provider)new BouncyCastleProvider());
                return Security.getProvider(providerName);
            }
        }
        LOG.error("Security Provider:{} is unknown", (Object)provider);
        throw new SecurityException("Unknown security provider:" + provider);
    }

    public long getS3AuthInfoMaxDate() {
        return this.getConfiguration().getTimeDuration("ozone.s3.token.max.lifetime", "3m", TimeUnit.MICROSECONDS);
    }
}

