/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Objects;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenIdentifier;
import org.apache.hadoop.io.Text;

@InterfaceAudience.Private
public class ContainerTokenIdentifier
extends ShortLivedTokenIdentifier {
    public static final Text KIND = new Text("HDDS_CONTAINER_TOKEN");
    private ContainerID containerID;

    public ContainerTokenIdentifier() {
    }

    public ContainerTokenIdentifier(String ownerId, ContainerID containerID, String certSerialId, Instant expiryDate) {
        super(ownerId, expiryDate, certSerialId);
        this.containerID = containerID;
    }

    public Text getKind() {
        return KIND;
    }

    public void write(DataOutput out) throws IOException {
        StorageContainerLocationProtocolProtos.ContainerTokenSecretProto.Builder builder = StorageContainerLocationProtocolProtos.ContainerTokenSecretProto.newBuilder().setOwnerId(this.getOwnerId()).setCertSerialId(this.getCertSerialId()).setExpiryDate(this.getExpiry().toEpochMilli()).setContainerId(this.containerID.getProtobuf());
        out.write(builder.build().toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        DataInputStream dis = (DataInputStream)in;
        if (!dis.markSupported()) {
            throw new IOException("Could not peek first byte.");
        }
        StorageContainerLocationProtocolProtos.ContainerTokenSecretProto proto = StorageContainerLocationProtocolProtos.ContainerTokenSecretProto.parseFrom((InputStream)((DataInputStream)in));
        this.setCertSerialId(proto.getCertSerialId());
        this.setExpiry(Instant.ofEpochMilli(proto.getExpiryDate()));
        this.setOwnerId(proto.getOwnerId());
        this.containerID = ContainerID.getFromProtobuf(proto.getContainerId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ContainerTokenIdentifier that = (ContainerTokenIdentifier)((Object)o);
        return super.equals((Object)that) && this.containerID == that.containerID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getExpiry());
    }

    @Override
    public String getService() {
        return this.containerID.toString();
    }
}

