/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class StandaloneReplicationConfig
implements ReplicationConfig {
    private final HddsProtos.ReplicationFactor replicationFactor;
    private static final String REPLICATION_TYPE = "STANDALONE";

    public StandaloneReplicationConfig(HddsProtos.ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public StandaloneReplicationConfig(String factorString) {
        HddsProtos.ReplicationFactor factor = null;
        try {
            factor = HddsProtos.ReplicationFactor.valueOf((int)Integer.parseInt(factorString));
        }
        catch (NumberFormatException ex) {
            factor = HddsProtos.ReplicationFactor.valueOf((String)factorString);
        }
        this.replicationFactor = factor;
    }

    public HddsProtos.ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public int getRequiredNodes() {
        return this.replicationFactor.getNumber();
    }

    @Override
    public HddsProtos.ReplicationType getReplicationType() {
        return HddsProtos.ReplicationType.STAND_ALONE;
    }

    @JsonProperty(value="replicationType")
    public String replicationType() {
        return REPLICATION_TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandaloneReplicationConfig that = (StandaloneReplicationConfig)o;
        return this.replicationFactor == that.replicationFactor;
    }

    public String toString() {
        return "STANDALONE/" + this.replicationFactor;
    }

    public int hashCode() {
        return Objects.hash(this.replicationFactor);
    }
}

