/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.regex.Pattern;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;

@ConfigGroup(prefix="ozone.replication")
public class ReplicationConfigValidator {
    @Config(key="allowed-configs", defaultValue="^((STANDALONE|RATIS)/(ONE|THREE))|(EC/(3-2|6-3|10-4))$", type=ConfigType.STRING, description="Regular expression to restrict enabled replication schemes", tags={ConfigTag.STORAGE})
    private String validationPattern;
    private Pattern validationRegexp;

    @PostConstruct
    public void init() {
        if (this.validationPattern != null && !this.validationPattern.equals("")) {
            this.validationRegexp = Pattern.compile(this.validationPattern);
        }
    }

    public ReplicationConfig validate(ReplicationConfig replicationConfig) {
        if (this.validationRegexp != null && !this.validationRegexp.matcher(replicationConfig.toString()).matches()) {
            throw new IllegalArgumentException("Invalid replication config " + replicationConfig.toString() + " Replication config should match " + this.validationPattern);
        }
        return replicationConfig;
    }
}

