/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public interface ReplicationConfig {
    public static ReplicationConfig fromTypeAndFactor(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) {
        switch (type) {
            case RATIS: {
                return new RatisReplicationConfig(factor);
            }
            case STAND_ALONE: {
                return new StandaloneReplicationConfig(factor);
            }
        }
        throw new UnsupportedOperationException("Not supported replication: " + type);
    }

    public static ReplicationConfig fromTypeAndFactor(ReplicationType type, ReplicationFactor factor) {
        return ReplicationConfig.fromTypeAndFactor(HddsProtos.ReplicationType.valueOf((String)type.name()), HddsProtos.ReplicationFactor.valueOf((String)factor.name()));
    }

    public static ReplicationConfig getDefault(ConfigurationSource config) {
        String replication = config.get("ozone.replication");
        String replType = config.get("ozone.replication.type");
        ReplicationConfig replicationConfig = null;
        if (replication != null && replType != null) {
            replicationConfig = ReplicationConfig.fromTypeAndString(ReplicationType.valueOf(replType), replication);
        }
        return replicationConfig;
    }

    public static ReplicationConfig fromProto(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) {
        switch (type) {
            case RATIS: 
            case STAND_ALONE: {
                return ReplicationConfig.fromTypeAndFactor(type, factor);
            }
        }
        throw new UnsupportedOperationException("Not supported replication: " + type);
    }

    public static HddsProtos.ReplicationFactor getLegacyFactor(ReplicationConfig replicationConfig) {
        if (replicationConfig instanceof RatisReplicationConfig) {
            return ((RatisReplicationConfig)replicationConfig).getReplicationFactor();
        }
        if (replicationConfig instanceof StandaloneReplicationConfig) {
            return ((StandaloneReplicationConfig)replicationConfig).getReplicationFactor();
        }
        throw new UnsupportedOperationException("factor is not valid property of replication " + replicationConfig.getReplicationType());
    }

    public static ReplicationConfig adjustReplication(ReplicationConfig replicationConfig, short replication) {
        switch (replicationConfig.getReplicationType()) {
            case RATIS: {
                return new RatisReplicationConfig(HddsProtos.ReplicationFactor.valueOf((int)replication));
            }
            case STAND_ALONE: {
                return new StandaloneReplicationConfig(HddsProtos.ReplicationFactor.valueOf((int)replication));
            }
        }
        return replicationConfig;
    }

    public static ReplicationConfig fromTypeAndString(ReplicationType replicationType, String replication) {
        switch (replicationType) {
            case RATIS: {
                return new RatisReplicationConfig(replication);
            }
            case STAND_ALONE: {
                return new StandaloneReplicationConfig(replication);
            }
        }
        throw new UnsupportedOperationException("String based replication config initialization is not supported for " + (Object)((Object)replicationType));
    }

    public HddsProtos.ReplicationType getReplicationType();

    public int getRequiredNodes();
}

