/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeDurationUtil {
    public static final Logger LOG = LoggerFactory.getLogger(TimeDurationUtil.class);

    private TimeDurationUtil() {
    }

    public static long getTimeDurationHelper(String name, String vStr, TimeUnit unit) {
        vStr = vStr.trim();
        ParsedTimeDuration vUnit = ParsedTimeDuration.unitFor(vStr = vStr.toLowerCase());
        if (null == vUnit) {
            LOG.warn("No unit for " + name + "(" + vStr + ") assuming " + (Object)((Object)unit));
            vUnit = ParsedTimeDuration.unitFor(unit);
            if (null == vUnit) {
                throw new IllegalArgumentException("Unexpected unit: " + (Object)((Object)unit));
            }
        } else {
            vStr = vStr.substring(0, vStr.lastIndexOf(vUnit.suffix()));
        }
        long raw = Long.parseLong(vStr);
        long converted = unit.convert(raw, vUnit.unit());
        if (vUnit.unit().convert(converted, unit) < raw) {
            LOG.warn("Possible loss of precision converting " + vStr + vUnit.suffix() + " to " + (Object)((Object)unit) + " for " + name);
        }
        return converted;
    }

    static enum ParsedTimeDuration {
        NS{

            @Override
            TimeUnit unit() {
                return TimeUnit.NANOSECONDS;
            }

            @Override
            String suffix() {
                return "ns";
            }
        }
        ,
        US{

            @Override
            TimeUnit unit() {
                return TimeUnit.MICROSECONDS;
            }

            @Override
            String suffix() {
                return "us";
            }
        }
        ,
        MS{

            @Override
            TimeUnit unit() {
                return TimeUnit.MILLISECONDS;
            }

            @Override
            String suffix() {
                return "ms";
            }
        }
        ,
        S{

            @Override
            TimeUnit unit() {
                return TimeUnit.SECONDS;
            }

            @Override
            String suffix() {
                return "s";
            }
        }
        ,
        M{

            @Override
            TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            @Override
            String suffix() {
                return "m";
            }
        }
        ,
        H{

            @Override
            TimeUnit unit() {
                return TimeUnit.HOURS;
            }

            @Override
            String suffix() {
                return "h";
            }
        }
        ,
        D{

            @Override
            TimeUnit unit() {
                return TimeUnit.DAYS;
            }

            @Override
            String suffix() {
                return "d";
            }
        };


        abstract TimeUnit unit();

        abstract String suffix();

        static ParsedTimeDuration unitFor(String s) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (!s.endsWith(ptd.suffix())) continue;
                return ptd;
            }
            return null;
        }

        static ParsedTimeDuration unitFor(TimeUnit unit) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (ptd.unit() != unit) continue;
                return ptd;
            }
            return null;
        }
    }
}

