/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigFileAppender;
import org.apache.hadoop.hdds.conf.ConfigGroup;

@SupportedAnnotationTypes(value={"org.apache.hadoop.hdds.conf.ConfigGroup"})
public class ConfigFileGenerator
extends AbstractProcessor {
    public static final String OUTPUT_FILE_NAME = "ozone-default-generated.xml";
    private static final SimpleTypeVisitor8<Element, Void> GET_PARENT_ELEMENT = new SimpleTypeVisitor8<Element, Void>(){

        @Override
        public Element visitDeclared(DeclaredType t, Void aVoid) {
            return t.asElement();
        }
    };

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block33: {
            if (roundEnv.processingOver()) {
                return false;
            }
            Filer filer = this.processingEnv.getFiler();
            try {
                boolean resourceExists = true;
                ConfigFileAppender appender = new ConfigFileAppender();
                try {
                    InputStream input = filer.getResource(StandardLocation.CLASS_OUTPUT, "", OUTPUT_FILE_NAME).openInputStream();
                    Object object = null;
                    try {
                        appender.load(input);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (input != null) {
                            if (object != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                input.close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException | NoSuchFileException ex) {
                    appender.init();
                    resourceExists = false;
                }
                Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(ConfigGroup.class);
                for (Element element : annotatedElements) {
                    TypeElement configurationObject = (TypeElement)element;
                    ConfigGroup configGroupAnnotation = configurationObject.getAnnotation(ConfigGroup.class);
                    TypeElement elementToCheck = configurationObject;
                    while (elementToCheck != null) {
                        this.writeConfigAnnotations(configGroupAnnotation, appender, elementToCheck);
                        if (!elementToCheck.getSuperclass().toString().equals("java.lang.Object")) {
                            elementToCheck = (TypeElement)elementToCheck.getSuperclass().accept(GET_PARENT_ELEMENT, null);
                            continue;
                        }
                        elementToCheck = null;
                    }
                }
                if (resourceExists) break block33;
                FileObject resource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", OUTPUT_FILE_NAME, new Element[0]);
                try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(resource.openOutputStream(), StandardCharsets.UTF_8);){
                    appender.write(outputStreamWriter);
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can't generate the config file from annotation: " + e);
            }
        }
        return false;
    }

    private void writeConfigAnnotations(ConfigGroup configGroup, ConfigFileAppender appender, TypeElement typeElement) {
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || element.getAnnotation(Config.class) == null) continue;
            Config configAnnotation = element.getAnnotation(Config.class);
            String key = configGroup.prefix() + "." + configAnnotation.key();
            appender.addConfig(key, configAnnotation.defaultValue(), configAnnotation.description(), configAnnotation.tags());
        }
    }
}

