/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;

public final class BucketArgs {
    private List<OzoneAcl> acls;
    private Boolean versioning;
    private StorageType storageType;
    private Map<String, String> metadata;
    private String bucketEncryptionKey;
    private final String sourceVolume;
    private final String sourceBucket;
    private long quotaInBytes;
    private long quotaInNamespace;
    private BucketLayout bucketLayout = BucketLayout.DEFAULT;

    private BucketArgs(Boolean versioning, StorageType storageType, List<OzoneAcl> acls, Map<String, String> metadata, String bucketEncryptionKey, String sourceVolume, String sourceBucket, long quotaInBytes, long quotaInNamespace, BucketLayout bucketLayout) {
        this.acls = acls;
        this.versioning = versioning;
        this.storageType = storageType;
        this.metadata = metadata;
        this.bucketEncryptionKey = bucketEncryptionKey;
        this.sourceVolume = sourceVolume;
        this.sourceBucket = sourceBucket;
        this.quotaInBytes = quotaInBytes;
        this.quotaInNamespace = quotaInNamespace;
        this.bucketLayout = bucketLayout;
    }

    public Boolean getVersioning() {
        return this.versioning;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getEncryptionKey() {
        return this.bucketEncryptionKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSourceVolume() {
        return this.sourceVolume;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }

    public static class Builder {
        private Boolean versioning;
        private StorageType storageType;
        private List<OzoneAcl> acls;
        private Map<String, String> metadata = new HashMap<String, String>();
        private String bucketEncryptionKey;
        private String sourceVolume;
        private String sourceBucket;
        private long quotaInBytes = -1L;
        private long quotaInNamespace = -1L;
        private BucketLayout bucketLayout;

        public Builder setVersioning(Boolean versionFlag) {
            this.versioning = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            this.acls = listOfAcls;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder setBucketEncryptionKey(String bek) {
            this.bucketEncryptionKey = bek;
            return this;
        }

        public Builder setSourceVolume(String volume) {
            this.sourceVolume = volume;
            return this;
        }

        public Builder setSourceBucket(String bucket) {
            this.sourceBucket = bucket;
            return this;
        }

        public Builder setQuotaInBytes(long quota) {
            this.quotaInBytes = quota;
            return this;
        }

        public Builder setQuotaInNamespace(long quota) {
            this.quotaInNamespace = quota;
            return this;
        }

        public Builder setBucketLayout(BucketLayout type) {
            this.bucketLayout = type;
            return this;
        }

        public BucketArgs build() {
            return new BucketArgs(this.versioning, this.storageType, this.acls, this.metadata, this.bucketEncryptionKey, this.sourceVolume, this.sourceBucket, this.quotaInBytes, this.quotaInNamespace, this.bucketLayout);
        }
    }
}

