/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.client.GrpcClientProtocolService;
import org.apache.ratis.grpc.metrics.intercept.server.MetricServerInterceptor;
import org.apache.ratis.grpc.server.GrpcAdminProtocolService;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcServerProtocolService;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpcWithProxy;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptors;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelOption;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.ClientAuth;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcService
extends RaftServerRpcWithProxy<GrpcServerProtocolClient, PeerProxyMap<GrpcServerProtocolClient>> {
    static final Logger LOG = LoggerFactory.getLogger(GrpcService.class);
    public static final String GRPC_SEND_SERVER_REQUEST = JavaUtils.getClassSimpleName(GrpcService.class) + ".sendRequest";
    private final List<Server> servers = new ArrayList<Server>(3);
    private final Supplier<InetSocketAddress> addressSupplier;
    private final Supplier<InetSocketAddress> clientServerAddressSupplier;
    private final Supplier<InetSocketAddress> adminServerAddressSupplier;
    private final GrpcClientProtocolService clientProtocolService;
    private final MetricServerInterceptor serverInterceptor;

    public static Builder newBuilder() {
        return new Builder();
    }

    public MetricServerInterceptor getServerInterceptor() {
        return this.serverInterceptor;
    }

    private GrpcService(RaftServer server, GrpcTlsConfig adminTlsConfig, GrpcTlsConfig clientTlsConfig, GrpcTlsConfig serverTlsConfig) {
        this(server, () -> ((RaftServer)server).getId(), GrpcConfigKeys.Admin.port(server.getProperties()), adminTlsConfig, GrpcConfigKeys.Client.port(server.getProperties()), clientTlsConfig, GrpcConfigKeys.Server.port(server.getProperties()), serverTlsConfig, GrpcConfigKeys.messageSizeMax(server.getProperties(), arg_0 -> ((Logger)LOG).info(arg_0)), RaftServerConfigKeys.Log.Appender.bufferByteLimit((RaftProperties)server.getProperties()), GrpcConfigKeys.flowControlWindow(server.getProperties(), arg_0 -> ((Logger)LOG).info(arg_0)), RaftServerConfigKeys.Rpc.requestTimeout((RaftProperties)server.getProperties()));
    }

    private GrpcService(RaftServer raftServer, Supplier<RaftPeerId> idSupplier, int adminPort, GrpcTlsConfig adminTlsConfig, int clientPort, GrpcTlsConfig clientTlsConfig, int serverPort, GrpcTlsConfig serverTlsConfig, SizeInBytes grpcMessageSizeMax, SizeInBytes appenderBufferSize, SizeInBytes flowControlWindow, TimeDuration requestTimeoutDuration) {
        super(idSupplier, id -> new PeerProxyMap(id.toString(), p -> new GrpcServerProtocolClient((RaftPeer)p, flowControlWindow.getSizeInt(), requestTimeoutDuration, serverTlsConfig)));
        NettyServerBuilder builder;
        if (appenderBufferSize.getSize() > grpcMessageSizeMax.getSize()) {
            throw new IllegalArgumentException("Illegal configuration: raft.server.log.appender.buffer.byte-limit = " + appenderBufferSize + " > " + "raft.grpc.message.size.max" + " = " + grpcMessageSizeMax);
        }
        this.clientProtocolService = new GrpcClientProtocolService(idSupplier, (RaftClientAsynchronousProtocol)raftServer);
        this.serverInterceptor = new MetricServerInterceptor(idSupplier, JavaUtils.getClassSimpleName(((Object)((Object)this)).getClass()) + "_" + serverPort);
        boolean separateAdminServer = adminPort != serverPort && adminPort > 0;
        boolean separateClientServer = clientPort != serverPort && clientPort > 0;
        NettyServerBuilder serverBuilder = GrpcService.startBuildingNettyServer(serverPort, serverTlsConfig, grpcMessageSizeMax, flowControlWindow);
        serverBuilder.addService(ServerInterceptors.intercept((BindableService)new GrpcServerProtocolService(idSupplier, raftServer), (ServerInterceptor[])new ServerInterceptor[]{this.serverInterceptor}));
        if (!separateAdminServer) {
            this.addAdminService(raftServer, serverBuilder);
        }
        if (!separateClientServer) {
            this.addClientService(serverBuilder);
        }
        Server server = serverBuilder.build();
        this.servers.add(server);
        this.addressSupplier = this.newAddressSupplier(serverPort, server);
        if (separateAdminServer) {
            builder = GrpcService.startBuildingNettyServer(adminPort, adminTlsConfig, grpcMessageSizeMax, flowControlWindow);
            this.addAdminService(raftServer, builder);
            Server adminServer = builder.build();
            this.servers.add(adminServer);
            this.adminServerAddressSupplier = this.newAddressSupplier(adminPort, adminServer);
        } else {
            this.adminServerAddressSupplier = this.addressSupplier;
        }
        if (separateClientServer) {
            builder = GrpcService.startBuildingNettyServer(clientPort, clientTlsConfig, grpcMessageSizeMax, flowControlWindow);
            this.addClientService(builder);
            Server clientServer = builder.build();
            this.servers.add(clientServer);
            this.clientServerAddressSupplier = this.newAddressSupplier(clientPort, clientServer);
        } else {
            this.clientServerAddressSupplier = this.addressSupplier;
        }
    }

    private MemoizedSupplier<InetSocketAddress> newAddressSupplier(int port, Server server) {
        return JavaUtils.memoize(() -> new InetSocketAddress(port != 0 ? port : server.getPort()));
    }

    private void addClientService(NettyServerBuilder builder) {
        builder.addService(ServerInterceptors.intercept((BindableService)this.clientProtocolService, (ServerInterceptor[])new ServerInterceptor[]{this.serverInterceptor}));
    }

    private void addAdminService(RaftServer raftServer, NettyServerBuilder nettyServerBuilder) {
        nettyServerBuilder.addService(ServerInterceptors.intercept((BindableService)new GrpcAdminProtocolService((AdminAsynchronousProtocol)raftServer), (ServerInterceptor[])new ServerInterceptor[]{this.serverInterceptor}));
    }

    private static NettyServerBuilder startBuildingNettyServer(int port, GrpcTlsConfig tlsConfig, SizeInBytes grpcMessageSizeMax, SizeInBytes flowControlWindow) {
        NettyServerBuilder nettyServerBuilder = NettyServerBuilder.forPort((int)port).withChildOption(ChannelOption.SO_REUSEADDR, (Object)true).maxInboundMessageSize(grpcMessageSizeMax.getSizeInt()).flowControlWindow(flowControlWindow.getSizeInt());
        if (tlsConfig != null) {
            SslContextBuilder sslContextBuilder;
            SslContextBuilder sslContextBuilder2 = sslContextBuilder = tlsConfig.isFileBasedConfig() ? SslContextBuilder.forServer((File)tlsConfig.getCertChainFile(), (File)tlsConfig.getPrivateKeyFile()) : SslContextBuilder.forServer((PrivateKey)tlsConfig.getPrivateKey(), (X509Certificate[])new X509Certificate[]{tlsConfig.getCertChain()});
            if (tlsConfig.getMtlsEnabled()) {
                sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
                if (tlsConfig.isFileBasedConfig()) {
                    sslContextBuilder.trustManager(tlsConfig.getTrustStoreFile());
                } else {
                    sslContextBuilder.trustManager(tlsConfig.getTrustStore());
                }
            }
            sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.OPENSSL);
            try {
                nettyServerBuilder.sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to build SslContext, tlsConfig=" + tlsConfig, ex);
            }
        }
        return nettyServerBuilder;
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    public void startImpl() {
        for (Server server : this.servers) {
            try {
                server.start();
            }
            catch (IOException e) {
                ExitUtils.terminate((int)1, (String)"Failed to start Grpc server", (Throwable)e, (Logger)LOG);
            }
            LOG.info("{}: {} started, listening on {}", new Object[]{this.getId(), JavaUtils.getClassSimpleName(((Object)((Object)this)).getClass()), server.getPort()});
        }
    }

    public void closeImpl() throws IOException {
        for (Server server : this.servers) {
            String name = this.getId() + ": shutdown server with port " + server.getPort();
            LOG.info("{} now", (Object)name);
            Server s = server.shutdownNow();
            super.closeImpl();
            try {
                s.awaitTermination();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw IOUtils.toInterruptedIOException((String)(name + " failed"), (InterruptedException)e);
            }
            LOG.info("{} successfully", (Object)name);
        }
        this.serverInterceptor.close();
    }

    public void notifyNotLeader(RaftGroupId groupId) {
        this.clientProtocolService.closeAllOrderedRequestStreamObservers(groupId);
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addressSupplier.get();
    }

    public InetSocketAddress getClientServerAddress() {
        return this.clientServerAddressSupplier.get();
    }

    public InetSocketAddress getAdminServerAddress() {
        return this.adminServerAddressSupplier.get();
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)GRPC_SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        RaftPeerId target = RaftPeerId.valueOf((ByteString)request.getServerRequest().getReplyId());
        return ((GrpcServerProtocolClient)this.getProxies().getProxy(target)).requestVote(request);
    }

    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)GRPC_SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        RaftPeerId target = RaftPeerId.valueOf((ByteString)request.getServerRequest().getReplyId());
        return ((GrpcServerProtocolClient)this.getProxies().getProxy(target)).startLeaderElection(request);
    }

    public static final class Builder {
        private RaftServer server;
        private GrpcTlsConfig tlsConfig;
        private GrpcTlsConfig adminTlsConfig;
        private GrpcTlsConfig clientTlsConfig;
        private GrpcTlsConfig serverTlsConfig;

        private Builder() {
        }

        public Builder setServer(RaftServer raftServer) {
            this.server = raftServer;
            return this;
        }

        public GrpcService build() {
            return new GrpcService(this.server, this.adminTlsConfig, this.clientTlsConfig, this.serverTlsConfig);
        }

        public Builder setTlsConfig(GrpcTlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public Builder setAdminTlsConfig(GrpcTlsConfig config) {
            this.adminTlsConfig = config;
            return this;
        }

        public Builder setClientTlsConfig(GrpcTlsConfig config) {
            this.clientTlsConfig = config;
            return this;
        }

        public Builder setServerTlsConfig(GrpcTlsConfig config) {
            this.serverTlsConfig = config;
            return this;
        }

        public GrpcTlsConfig getTlsConfig() {
            return this.tlsConfig;
        }
    }
}

