/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;

public class ContinueToken {
    private String lastKey;
    private String lastDir;
    private static final String CONTINUE_TOKEN_SEPARATOR = "-";

    public ContinueToken(String lastKey, String lastDir) {
        Preconditions.checkNotNull((Object)lastKey, (Object)"The last key can't be null in the continue token.");
        this.lastKey = lastKey;
        if (lastDir != null && lastDir.length() > 0) {
            this.lastDir = lastDir;
        }
    }

    public String encodeToString() {
        if (this.lastKey != null) {
            byte[] rawLastKey = this.lastKey.getBytes(StandardCharsets.UTF_8);
            byte[] rawLastDir = this.lastDir == null ? new byte[]{} : this.lastDir.getBytes(StandardCharsets.UTF_8);
            ByteBuffer buffer = ByteBuffer.allocate(4 + rawLastKey.length + rawLastDir.length);
            buffer.putInt(rawLastKey.length);
            buffer.put(rawLastKey);
            if (this.lastDir != null) {
                buffer.put(rawLastDir);
            }
            String hex = Hex.encodeHexString((byte[])buffer.array());
            String digest = DigestUtils.sha256Hex((String)hex);
            return hex + CONTINUE_TOKEN_SEPARATOR + digest;
        }
        return null;
    }

    public static ContinueToken decodeFromString(String key) throws OS3Exception {
        if (key != null) {
            int indexSeparator = key.indexOf(CONTINUE_TOKEN_SEPARATOR);
            if (indexSeparator == -1) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, key);
            }
            String hex = key.substring(0, indexSeparator);
            String digest = key.substring(indexSeparator + 1);
            try {
                ContinueToken.checkHash(key, hex, digest);
                ByteBuffer buffer = ByteBuffer.wrap(Hex.decodeHex((String)hex));
                int keySize = buffer.getInt();
                byte[] actualKeyBytes = new byte[keySize];
                buffer.get(actualKeyBytes);
                byte[] actualDirBytes = new byte[buffer.remaining()];
                buffer.get(actualDirBytes);
                return new ContinueToken(new String(actualKeyBytes, StandardCharsets.UTF_8), new String(actualDirBytes, StandardCharsets.UTF_8));
            }
            catch (DecoderException ex) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, key);
                os3Exception.setErrorMessage("The continuation token provided is incorrect");
                throw os3Exception;
            }
        }
        return null;
    }

    private static void checkHash(String key, String hex, String digest) throws OS3Exception {
        String digestActualKey = DigestUtils.sha256Hex((String)hex);
        if (!digest.equals(digestActualKey)) {
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, key);
            ex.setErrorMessage("The continuation token provided is incorrect");
            throw ex;
        }
    }

    public String getLastKey() {
        return this.lastKey;
    }

    public void setLastKey(String lastKey) {
        this.lastKey = lastKey;
    }

    public String getLastDir() {
        return this.lastDir;
    }

    public void setLastDir(String lastDir) {
        this.lastDir = lastDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContinueToken that = (ContinueToken)o;
        return this.lastKey.equals(that.lastKey) && Objects.equals(this.lastDir, that.lastDir);
    }

    public int hashCode() {
        return Objects.hash(this.lastKey);
    }

    public String toString() {
        return "ContinueToken{lastKey='" + this.lastKey + '\'' + ", lastDir='" + this.lastDir + '\'' + '}';
    }
}

