/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import com.google.common.annotations.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.signature.AWSSignatureProcessor;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.util.StringUtils;
import org.apache.kerby.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringToSignProducer {
    public static final String X_AMZ_CONTENT_SHA256 = "X-Amz-Content-SHA256";
    public static final String X_AMAZ_DATE = "X-Amz-Date";
    private static final Logger LOG = LoggerFactory.getLogger(StringToSignProducer.class);
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String NEWLINE = "\n";
    private static final String HOST = "host";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    private static final long PRESIGN_URL_MAX_EXPIRATION_SECONDS = 604800L;
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneOffset.UTC);

    private StringToSignProducer() {
    }

    public static String createSignatureBase(SignatureInfo signatureInfo, ContainerRequestContext context) throws Exception {
        return StringToSignProducer.createSignatureBase(signatureInfo, context.getUriInfo().getRequestUri().getScheme(), context.getMethod(), context.getUriInfo().getRequestUri().getPath(), AWSSignatureProcessor.LowerCaseKeyStringMap.fromHeaderMap((MultivaluedMap<String, String>)context.getHeaders()), StringToSignProducer.fromMultiValueToSingleValueMap((MultivaluedMap<String, String>)context.getUriInfo().getQueryParameters()));
    }

    @VisibleForTesting
    public static String createSignatureBase(SignatureInfo signatureInfo, String scheme, String method, String uri, AWSSignatureProcessor.LowerCaseKeyStringMap headers, Map<String, String> queryParams) throws Exception {
        StringBuilder strToSign = new StringBuilder();
        String credentialScope = signatureInfo.getCredentialScope();
        uri = uri.trim().length() > 0 ? uri : "/";
        strToSign.append(signatureInfo.getAlgorithm() + NEWLINE);
        strToSign.append(signatureInfo.getDateTime() + NEWLINE);
        strToSign.append(credentialScope + NEWLINE);
        String canonicalRequest = StringToSignProducer.buildCanonicalRequest(scheme, method, uri, signatureInfo.getSignedHeaders(), headers, queryParams, !signatureInfo.isSignPayload());
        strToSign.append(StringToSignProducer.hash(canonicalRequest));
        if (LOG.isDebugEnabled()) {
            LOG.debug("canonicalRequest:[{}]", (Object)canonicalRequest);
            LOG.debug("StringToSign:[{}]", (Object)strToSign);
        }
        return strToSign.toString();
    }

    public static Map<String, String> fromMultiValueToSingleValueMap(MultivaluedMap<String, String> queryParameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : queryParameters.keySet()) {
            result.put(key, (String)queryParameters.getFirst((Object)key));
        }
        return result;
    }

    public static String hash(String payload) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(payload.getBytes(UTF_8));
        return Hex.encode((byte[])md.digest()).toLowerCase();
    }

    @VisibleForTesting
    public static String buildCanonicalRequest(String schema, String method, String uri, String signedHeaders, Map<String, String> headers, Map<String, String> queryParams, boolean unsignedPayload) throws OS3Exception {
        Iterable<String> parts = StringToSignProducer.split("/", uri);
        ArrayList<String> encParts = new ArrayList<String>();
        for (String p : parts) {
            encParts.add(StringToSignProducer.urlEncode(p));
        }
        String canonicalUri = StringToSignProducer.join("/", encParts);
        String canonicalQueryStr = StringToSignProducer.getQueryParamString(queryParams);
        StringBuilder canonicalHeaders = new StringBuilder();
        for (String header : StringUtils.getStringCollection((String)signedHeaders, (String)";")) {
            canonicalHeaders.append(header.toLowerCase());
            canonicalHeaders.append(":");
            if (headers.containsKey(header)) {
                String headerValue = headers.get(header);
                canonicalHeaders.append(headerValue);
                canonicalHeaders.append(NEWLINE);
                StringToSignProducer.validateSignedHeader(schema, header, headerValue);
                continue;
            }
            throw new RuntimeException("Header " + header + " not present in request but requested to be signed.");
        }
        String payloadHash = UNSIGNED_PAYLOAD.equals(headers.get(X_AMZ_CONTENT_SHA256)) || unsignedPayload ? UNSIGNED_PAYLOAD : headers.get(X_AMZ_CONTENT_SHA256);
        String canonicalRequest = method + NEWLINE + canonicalUri + NEWLINE + canonicalQueryStr + NEWLINE + canonicalHeaders + NEWLINE + signedHeaders + NEWLINE + payloadHash;
        return canonicalRequest;
    }

    private static String join(String glue, List<String> parts) {
        StringBuilder result = new StringBuilder();
        boolean addSeparator = false;
        for (String p : parts) {
            if (addSeparator) {
                result.append(glue);
            }
            result.append(p);
            addSeparator = true;
        }
        return result.toString();
    }

    private static Iterable<String> split(String regex, String whole) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(whole);
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while (m.find()) {
            result.add(whole.substring(pos, m.start()));
            pos = m.end();
        }
        result.add(whole.substring(pos));
        return result;
    }

    private static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, UTF_8.name()).replaceAll("\\+", "%20").replaceAll("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getQueryParamString(Map<String, String> queryMap) {
        ArrayList<String> params = new ArrayList<String>(queryMap.keySet());
        Collections.sort(params, (o1, o2) -> o1.equals(o2) ? ((String)queryMap.get(o1)).compareTo((String)queryMap.get(o2)) : o1.compareTo((String)o2));
        StringBuilder result = new StringBuilder();
        for (String p : params) {
            if (p.equals("X-Amz-Signature")) continue;
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(StringToSignProducer.urlEncode(p));
            result.append('=');
            result.append(StringToSignProducer.urlEncode(queryMap.get(p)));
        }
        return result.toString();
    }

    @VisibleForTesting
    static void validateSignedHeader(String schema, String header, String headerValue) throws OS3Exception {
        switch (header) {
            case "host": {
                try {
                    URI hostUri = new URI(schema + "://" + headerValue);
                    InetAddress.getByName(hostUri.getHost());
                    break;
                }
                catch (URISyntaxException | UnknownHostException e) {
                    LOG.error("Host value mentioned in signed header is not valid. Host:{}", (Object)headerValue);
                    throw S3ErrorTable.S3_AUTHINFO_CREATION_ERROR;
                }
            }
            case "X-Amz-Date": {
                LocalDate date = LocalDate.parse(headerValue, TIME_FORMATTER);
                LocalDate now = LocalDate.now();
                if (!date.isBefore(now.minus(604800L, ChronoUnit.SECONDS)) && !date.isAfter(now.plus(604800L, ChronoUnit.SECONDS))) break;
                LOG.error("AWS date not in valid range. Request timestamp:{} should not be older than {} seconds.", (Object)headerValue, (Object)604800L);
                throw S3ErrorTable.S3_AUTHINFO_CREATION_ERROR;
            }
            case "X-Amz-Content-SHA256": {
                break;
            }
        }
    }
}

