/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Credential {
    private static final Logger LOG = LoggerFactory.getLogger(Credential.class);
    private String accessKeyID;
    private String date;
    private String awsRegion;
    private String awsService;
    private String awsRequest;
    private String credential;

    Credential(String cred) throws OS3Exception {
        this.credential = cred;
        this.parseCredential();
    }

    public void parseCredential() throws OS3Exception {
        String[] split = this.credential.split("/");
        switch (split.length) {
            case 5: {
                this.accessKeyID = split[0].trim();
                this.date = split[1].trim();
                this.awsRegion = split[2].trim();
                this.awsService = split[3].trim();
                this.awsRequest = split[4].trim();
                return;
            }
            case 6: {
                this.accessKeyID = split[0] + "/" + split[1];
                this.date = split[2].trim();
                this.awsRegion = split[3].trim();
                this.awsService = split[4].trim();
                this.awsRequest = split[5].trim();
                return;
            }
        }
        LOG.error("Credentials not in expected format. credential:{}", (Object)this.credential);
        throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.credential);
    }

    public String getAccessKeyID() {
        return this.accessKeyID;
    }

    public String getDate() {
        return this.date;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getAwsService() {
        return this.awsService;
    }

    public String getAwsRequest() {
        return this.awsRequest;
    }

    public String getCredential() {
        return this.credential;
    }

    public String createScope() {
        return String.format("%s/%s/%s/%s", this.getDate(), this.getAwsRegion(), this.getAwsService(), this.getAwsRequest());
    }
}

