/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import com.google.common.annotations.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.signature.Credential;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.ozone.s3.signature.SignatureParser;
import org.apache.hadoop.ozone.s3.signature.StringToSignProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationV4QueryParser
implements SignatureParser {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationV4QueryParser.class);
    private final Map<String, String> queryParameters;

    public AuthorizationV4QueryParser(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    @Override
    public SignatureInfo parseSignature() throws OS3Exception {
        if (!this.queryParameters.containsKey("X-Amz-Signature")) {
            return null;
        }
        this.validateDateAndExpires();
        String rawCredential = this.queryParameters.get("X-Amz-Credential");
        Credential credential = null;
        try {
            credential = new Credential(URLDecoder.decode(rawCredential, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("X-Amz-Credential is not proper URL encoded");
        }
        return new SignatureInfo(SignatureInfo.Version.V4, credential.getDate(), this.queryParameters.get("X-Amz-Date"), credential.getAccessKeyID(), this.queryParameters.get("X-Amz-Signature"), this.queryParameters.get("X-Amz-SignedHeaders"), credential.createScope(), this.queryParameters.get("X-Amz-Algorithm"), false);
    }

    @VisibleForTesting
    protected void validateDateAndExpires() {
        String dateString = this.queryParameters.get("X-Amz-Date");
        String expiresString = this.queryParameters.get("X-Amz-Expires");
        if (expiresString != null && expiresString.length() > 0) {
            Long expires = Long.valueOf(expiresString);
            if (ZonedDateTime.parse(dateString, StringToSignProducer.TIME_FORMATTER).plus(expires, ChronoUnit.SECONDS).isBefore(ZonedDateTime.now())) {
                throw new IllegalArgumentException("Pre-signed S3 url is expired");
            }
        }
    }
}

