/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.signature.Credential;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.ozone.s3.signature.SignatureParser;
import org.apache.hadoop.ozone.s3.signature.SignatureProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationV4HeaderParser
implements SignatureParser {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationV4HeaderParser.class);
    private static final String CREDENTIAL = "Credential=";
    private static final String SIGNEDHEADERS = "SignedHeaders=";
    private static final String SIGNATURE = "Signature=";
    private String authHeader;
    private String dateHeader;

    public AuthorizationV4HeaderParser(String authHeader, String dateHeader) {
        this.authHeader = authHeader;
        this.dateHeader = dateHeader;
    }

    @Override
    public SignatureInfo parseSignature() throws OS3Exception {
        if (this.authHeader == null || !this.authHeader.startsWith("AWS4")) {
            return null;
        }
        int firstSep = this.authHeader.indexOf(32);
        if (firstSep < 0) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        String[] split = this.authHeader.substring(firstSep + 1).trim().split(", *");
        if (split.length != 3) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        String algorithm = this.parseAlgorithm(this.authHeader.substring(0, firstSep));
        Credential credentialObj = this.parseCredentials(split[0]);
        String signedHeaders = this.parseSignedHeaders(split[1]);
        String signature = this.parseSignature(split[2]);
        return new SignatureInfo(SignatureInfo.Version.V4, credentialObj.getDate(), this.dateHeader, credentialObj.getAccessKeyID(), signature, signedHeaders, credentialObj.createScope(), algorithm, true);
    }

    private String parseSignedHeaders(String signedHeadersStr) throws OS3Exception {
        if (StringUtils.isNotEmpty((CharSequence)signedHeadersStr) && signedHeadersStr.startsWith(SIGNEDHEADERS)) {
            String parsedSignedHeaders = signedHeadersStr.substring(SIGNEDHEADERS.length());
            Collection signedHeaders = org.apache.hadoop.util.StringUtils.getStringCollection((String)parsedSignedHeaders, (String)";");
            if (signedHeaders.size() == 0) {
                LOG.error("No signed headers found. Authheader:{}", (Object)this.authHeader);
                throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
            }
            return parsedSignedHeaders;
        }
        LOG.error("No signed headers found. Authheader:{}", (Object)this.authHeader);
        throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
    }

    private String parseSignature(String signature) throws OS3Exception {
        if (signature.startsWith(SIGNATURE)) {
            String parsedSignature = signature.substring(SIGNATURE.length());
            if (StringUtils.isEmpty((CharSequence)parsedSignature)) {
                LOG.error("Signature can't be empty: {}", (Object)signature);
                throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
            }
            try {
                Hex.decodeHex((String)parsedSignature);
            }
            catch (DecoderException e) {
                LOG.error("Signature:{} should be in hexa-decimal encoding.", (Object)signature);
                throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
            }
            return parsedSignature;
        }
        LOG.error("No signature found: {}", (Object)signature);
        throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
    }

    private Credential parseCredentials(String credential) throws OS3Exception {
        Credential credentialObj = null;
        if (!StringUtils.isNotEmpty((CharSequence)credential) || !credential.startsWith(CREDENTIAL)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        credential = credential.substring(CREDENTIAL.length());
        credentialObj = new Credential(credential);
        if (credentialObj.getAccessKeyID().isEmpty()) {
            LOG.error("AWS access id shouldn't be empty. credential:{}", (Object)credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        if (credentialObj.getAwsRegion().isEmpty()) {
            LOG.error("AWS region shouldn't be empty. credential:{}", (Object)credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        if (credentialObj.getAwsRequest().isEmpty()) {
            LOG.error("AWS request shouldn't be empty. credential:{}", (Object)credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        if (credentialObj.getAwsService().isEmpty()) {
            LOG.error("AWS service shouldn't be empty. credential:{}", (Object)credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        if (credentialObj.getDate().isEmpty()) {
            LOG.error("AWS date shouldn't be empty. credential:{}", (Object)credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.validateDateRange(credentialObj);
        return credentialObj;
    }

    @VisibleForTesting
    public void validateDateRange(Credential credentialObj) throws OS3Exception {
        LocalDate now;
        LocalDate date = LocalDate.parse(credentialObj.getDate(), SignatureProcessor.DATE_FORMATTER);
        if (date.isBefore((now = LocalDate.now()).minus(1L, ChronoUnit.DAYS)) || date.isAfter(now.plus(1L, ChronoUnit.DAYS))) {
            LOG.error("AWS date not in valid range. Date:{} should not be older than 1 day(i.e yesterday) and greater than 1 day(i.e tomorrow).", (Object)date);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
    }

    private String parseAlgorithm(String algorithm) throws OS3Exception {
        if (StringUtils.isEmpty((CharSequence)algorithm) || !algorithm.equals("AWS4-HMAC-SHA256")) {
            LOG.error("Unexpected hash algorithm. Algo:{}", (Object)algorithm);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        return algorithm;
    }
}

