/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.ozone.s3.signature.SignatureParser;

public class AuthorizationV2HeaderParser
implements SignatureParser {
    public static final String IDENTIFIER = "AWS";
    private final String authHeader;

    public AuthorizationV2HeaderParser(String authHeader) {
        this.authHeader = authHeader;
    }

    @Override
    public SignatureInfo parseSignature() throws OS3Exception {
        if (this.authHeader == null || !this.authHeader.startsWith("AWS ")) {
            return null;
        }
        String[] split = this.authHeader.split(" ");
        if (split.length != 2) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        String identifier = split[0];
        if (!IDENTIFIER.equals(identifier)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        String[] remainingSplit = split[1].split(":");
        if (remainingSplit.length != 2) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        String accessKeyID = remainingSplit[0];
        String signature = remainingSplit[1];
        if (StringUtils.isBlank((CharSequence)accessKeyID) || StringUtils.isBlank((CharSequence)signature)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        return new SignatureInfo(SignatureInfo.Version.V2, "", "", accessKeyID, signature, "", "", "", false);
    }
}

