/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.signature.AuthorizationV2HeaderParser;
import org.apache.hadoop.ozone.s3.signature.AuthorizationV4HeaderParser;
import org.apache.hadoop.ozone.s3.signature.AuthorizationV4QueryParser;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.ozone.s3.signature.SignatureParser;
import org.apache.hadoop.ozone.s3.signature.SignatureProcessor;
import org.apache.hadoop.ozone.s3.signature.StringToSignProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class AWSSignatureProcessor
implements SignatureProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AWSSignatureProcessor.class);
    @Context
    private ContainerRequestContext context;

    @Override
    public SignatureInfo parseSignature() throws OS3Exception {
        SignatureParser parser;
        LowerCaseKeyStringMap headers = LowerCaseKeyStringMap.fromHeaderMap((MultivaluedMap<String, String>)this.context.getHeaders());
        String authHeader = headers.get("Authorization");
        ArrayList<SignatureParser> signatureParsers = new ArrayList<SignatureParser>();
        signatureParsers.add(new AuthorizationV4HeaderParser(authHeader, headers.get("X-Amz-Date")));
        signatureParsers.add(new AuthorizationV4QueryParser(StringToSignProducer.fromMultiValueToSingleValueMap((MultivaluedMap<String, String>)this.context.getUriInfo().getQueryParameters())));
        signatureParsers.add(new AuthorizationV2HeaderParser(authHeader));
        SignatureInfo signatureInfo = null;
        Iterator iterator = signatureParsers.iterator();
        while (iterator.hasNext() && (signatureInfo = (parser = (SignatureParser)iterator.next()).parseSignature()) == null) {
        }
        if (signatureInfo == null) {
            signatureInfo = new SignatureInfo(SignatureInfo.Version.NONE, "", "", "", "", "", "", "", false);
        }
        return signatureInfo;
    }

    @VisibleForTesting
    public void setContext(ContainerRequestContext context) {
        this.context = context;
    }

    public static class LowerCaseKeyStringMap
    implements Map<String, String> {
        private Map<String, String> delegate = new HashMap<String, String>();

        public static LowerCaseKeyStringMap fromHeaderMap(MultivaluedMap<String, String> rawHeaders) {
            LowerCaseKeyStringMap headers = new LowerCaseKeyStringMap();
            for (Map.Entry headerEntry : rawHeaders.entrySet()) {
                if (0 >= ((List)headerEntry.getValue()).size()) continue;
                String headerKey = (String)headerEntry.getKey();
                if (headers.containsKey(headerKey)) {
                    headers.put(headerKey, headers.get(headerKey) + "," + (String)((List)headerEntry.getValue()).get(0));
                    continue;
                }
                headers.put(headerKey, (String)((List)headerEntry.getValue()).get(0));
            }
            headers.fixContentType();
            if (LOG.isTraceEnabled()) {
                headers.keySet().forEach((? super T k) -> LOG.trace("Header:{},value:{}", k, (Object)headers.get(k)));
            }
            return headers;
        }

        @VisibleForTesting
        protected void fixContentType() {
            if (this.containsKey("X-Ozone-Original-Content-Type")) {
                this.put("Content-Type", this.get("X-Ozone-Original-Content-Type"));
            }
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key.toString().toLowerCase());
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public String get(Object key) {
            return this.delegate.get(key.toString().toLowerCase());
        }

        @Override
        public String put(String key, String value) {
            return this.delegate.put(key.toLowerCase(), value);
        }

        @Override
        public String remove(Object key) {
            return this.delegate.remove(key.toString());
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
                this.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<String> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.delegate.entrySet();
        }
    }
}

