/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.exception;

import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3ErrorTable {
    private static final Logger LOG = LoggerFactory.getLogger(S3ErrorTable.class);
    public static final OS3Exception INVALID_URI = new OS3Exception("InvalidURI", "Couldn't parse the specified URI.", 400);
    public static final OS3Exception NO_SUCH_VOLUME = new OS3Exception("NoSuchVolume", "The specified volume does not exist", 404);
    public static final OS3Exception NO_SUCH_BUCKET = new OS3Exception("NoSuchBucket", "The specified bucket does not exist", 404);
    public static final OS3Exception AUTH_PROTOCOL_NOT_SUPPORTED = new OS3Exception("AuthProtocolNotSupported", "Auth protocol used for this request is not supported.", 400);
    public static final OS3Exception S3_AUTHINFO_CREATION_ERROR = new OS3Exception("InvalidRequest", "Error creating s3 auth info.", 400);
    public static final OS3Exception BUCKET_NOT_EMPTY = new OS3Exception("BucketNotEmpty", "The bucket you tried to delete is not empty.", 409);
    public static final OS3Exception MALFORMED_HEADER = new OS3Exception("AuthorizationHeaderMalformed", "The authorization header you provided is invalid.", 404);
    public static final OS3Exception NO_SUCH_KEY = new OS3Exception("NoSuchKey", "The specified key does not exist", 404);
    public static final OS3Exception INVALID_ARGUMENT = new OS3Exception("InvalidArgument", "Invalid Argument", 400);
    public static final OS3Exception INVALID_REQUEST = new OS3Exception("InvalidRequest", "Invalid Request", 400);
    public static final OS3Exception INVALID_RANGE = new OS3Exception("InvalidRange", "The requested range is not satisfiable", 416);
    public static final OS3Exception NO_SUCH_UPLOAD = new OS3Exception("NoSuchUpload", "The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.", 404);
    public static final OS3Exception INVALID_BUCKET_NAME = new OS3Exception("InvalidBucketName", "The specified bucket is not valid.", 400);
    public static final OS3Exception INVALID_PART = new OS3Exception("InvalidPart", "One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.", 400);
    public static final OS3Exception INVALID_PART_ORDER = new OS3Exception("InvalidPartOrder", "The list of parts was not in ascending order. The parts list must be specified in order by part number.", 400);
    public static final OS3Exception ENTITY_TOO_SMALL = new OS3Exception("EntityTooSmall", "Your proposed upload is smaller than the minimum allowed object size. Each part must be at least 5 MB in size, except the last part.", 400);
    public static final OS3Exception INTERNAL_ERROR = new OS3Exception("InternalError", "We encountered an internal error. Please try again.", 500);
    public static final OS3Exception ACCESS_DENIED = new OS3Exception("AccessDenied", "User doesn't have the right to access this resource.", 403);
    public static final OS3Exception PRECOND_FAILED = new OS3Exception("PreconditionFailed", "At least one of the pre-conditions you specified did not hold", 412);
    public static final OS3Exception NOT_IMPLEMENTED = new OS3Exception("NotImplemented", "This part of feature is not implemented yet.", 501);

    private S3ErrorTable() {
    }

    public static OS3Exception newError(OS3Exception e, String resource) {
        OS3Exception err = new OS3Exception(e.getCode(), e.getErrorMessage(), e.getHttpCode());
        err.setResource(resource);
        LOG.error(err.toXml(), (Throwable)e);
        return err;
    }
}

