/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadList;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.s3.commontypes.KeyMetadata;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.endpoint.ListMultipartUploadsResult;
import org.apache.hadoop.ozone.s3.endpoint.ListObjectResponse;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteRequest;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteResponse;
import org.apache.hadoop.ozone.s3.endpoint.PutBucketAclRequestUnmarshaller;
import org.apache.hadoop.ozone.s3.endpoint.S3Acl;
import org.apache.hadoop.ozone.s3.endpoint.S3BucketAcl;
import org.apache.hadoop.ozone.s3.endpoint.S3Owner;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.util.ContinueToken;
import org.apache.hadoop.ozone.s3.util.S3StorageType;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{bucket}")
public class BucketEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(BucketEndpoint.class);

    @GET
    @SuppressFBWarnings
    public Response get(@PathParam(value="bucket") String bucketName, @QueryParam(value="delimiter") String delimiter, @QueryParam(value="encoding-type") String encodingType, @QueryParam(value="marker") String marker, @DefaultValue(value="1000") @QueryParam(value="max-keys") int maxKeys, @QueryParam(value="prefix") String prefix, @QueryParam(value="browser") String browser, @QueryParam(value="continuation-token") String continueToken, @QueryParam(value="start-after") String startAfter, @QueryParam(value="uploads") String uploads, @QueryParam(value="acl") String aclMarker, @Context HttpHeaders hh) throws OS3Exception, IOException {
        Iterator ozoneKeyIterator;
        if (aclMarker != null) {
            S3BucketAcl result = this.getAcl(bucketName);
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        if (browser != null) {
            InputStream browserPage = this.getClass().getResourceAsStream("/browser.html");
            return Response.ok((Object)browserPage, (MediaType)MediaType.TEXT_HTML_TYPE).build();
        }
        if (uploads != null) {
            return this.listMultipartUploads(bucketName, prefix);
        }
        if (prefix == null) {
            prefix = "";
        }
        OzoneBucket bucket = this.getBucket(bucketName);
        ContinueToken decodedToken = ContinueToken.decodeFromString(continueToken);
        if (startAfter == null && marker != null) {
            startAfter = marker;
        }
        try {
            ozoneKeyIterator = startAfter != null && continueToken != null ? bucket.listKeys(prefix, decodedToken.getLastKey()) : (startAfter != null && continueToken == null ? bucket.listKeys(prefix, startAfter) : (startAfter == null && continueToken != null ? bucket.listKeys(prefix, decodedToken.getLastKey()) : bucket.listKeys(prefix)));
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName);
            }
            throw ex;
        }
        ListObjectResponse response = new ListObjectResponse();
        response.setDelimiter(delimiter);
        response.setName(bucketName);
        response.setPrefix(prefix);
        response.setMarker(marker == null ? "" : marker);
        response.setMaxKeys(maxKeys);
        response.setEncodingType("url");
        response.setTruncated(false);
        response.setContinueToken(continueToken);
        String prevDir = null;
        if (continueToken != null) {
            prevDir = decodedToken.getLastDir();
        }
        String lastKey = null;
        int count = 0;
        while (ozoneKeyIterator.hasNext()) {
            OzoneKey next = (OzoneKey)ozoneKeyIterator.next();
            String relativeKeyName = next.getName().substring(prefix.length());
            int depth = StringUtils.countMatches((CharSequence)relativeKeyName, (CharSequence)delimiter);
            if (delimiter != null) {
                if (depth > 0) {
                    String dirName = relativeKeyName.substring(0, relativeKeyName.indexOf(delimiter));
                    if (!dirName.equals(prevDir)) {
                        response.addPrefix(prefix + dirName + delimiter);
                        prevDir = dirName;
                        ++count;
                    }
                } else if (relativeKeyName.endsWith(delimiter)) {
                    response.addPrefix(relativeKeyName);
                    ++count;
                } else {
                    this.addKey(response, next);
                    ++count;
                }
            } else {
                this.addKey(response, next);
                ++count;
            }
            if (count != maxKeys) continue;
            lastKey = next.getName();
            break;
        }
        response.setKeyCount(count);
        if (count < maxKeys) {
            response.setTruncated(false);
        } else if (ozoneKeyIterator.hasNext()) {
            response.setTruncated(true);
            ContinueToken nextToken = new ContinueToken(lastKey, prevDir);
            response.setNextToken(nextToken.encodeToString());
            response.setNextMarker(lastKey);
        } else {
            response.setTruncated(false);
        }
        response.setKeyCount(response.getCommonPrefixes().size() + response.getContents().size());
        return Response.ok((Object)response).build();
    }

    @PUT
    public Response put(@PathParam(value="bucket") String bucketName, @QueryParam(value="acl") String aclMarker, @Context HttpHeaders httpHeaders, InputStream body) throws IOException, OS3Exception {
        if (aclMarker != null) {
            return this.putAcl(bucketName, httpHeaders, body);
        }
        try {
            String location = this.createS3Bucket(bucketName);
            LOG.info("Location is {}", (Object)location);
            return Response.status((int)200).header("Location", (Object)location).build();
        }
        catch (OMException exception) {
            LOG.error("Error in Create Bucket Request for bucket: {}", (Object)bucketName, (Object)exception);
            if (exception.getResult() == OMException.ResultCodes.INVALID_BUCKET_NAME) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_BUCKET_NAME, bucketName);
            }
            throw exception;
        }
    }

    public Response listMultipartUploads(@PathParam(value="bucket") String bucketName, @QueryParam(value="prefix") String prefix) throws OS3Exception, IOException {
        OzoneMultipartUploadList ozoneMultipartUploadList;
        OzoneBucket bucket = this.getBucket(bucketName);
        try {
            ozoneMultipartUploadList = bucket.listMultipartUploads(prefix);
        }
        catch (OMException exception) {
            if (exception.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, prefix);
            }
            throw exception;
        }
        ListMultipartUploadsResult result = new ListMultipartUploadsResult();
        result.setBucket(bucketName);
        ozoneMultipartUploadList.getUploads().forEach(upload -> result.addUpload(new ListMultipartUploadsResult.Upload(upload.getKeyName(), upload.getUploadId(), upload.getCreationTime(), S3StorageType.fromReplicationType(upload.getReplicationType(), upload.getReplicationFactor()))));
        return Response.ok((Object)result).build();
    }

    @HEAD
    public Response head(@PathParam(value="bucket") String bucketName) throws OS3Exception, IOException {
        try {
            this.getBucket(bucketName);
        }
        catch (OS3Exception ex) {
            LOG.error("Exception occurred in headBucket", (Throwable)ex);
            throw ex;
        }
        return Response.ok().build();
    }

    @DELETE
    public Response delete(@PathParam(value="bucket") String bucketName) throws IOException, OS3Exception {
        try {
            this.deleteS3Bucket(bucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_EMPTY) {
                throw S3ErrorTable.newError(S3ErrorTable.BUCKET_NOT_EMPTY, bucketName);
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName);
            }
            throw ex;
        }
        return Response.status((int)204).build();
    }

    @POST
    @Produces(value={"application/xml"})
    public MultiDeleteResponse multiDelete(@PathParam(value="bucket") String bucketName, @QueryParam(value="delete") String delete, MultiDeleteRequest request) throws OS3Exception, IOException {
        OzoneBucket bucket = this.getBucket(bucketName);
        MultiDeleteResponse result = new MultiDeleteResponse();
        if (request.getObjects() != null) {
            for (MultiDeleteRequest.DeleteObject keyToDelete : request.getObjects()) {
                try {
                    bucket.deleteKey(keyToDelete.getKey());
                    if (request.isQuiet()) continue;
                    result.addDeleted(new MultiDeleteResponse.DeletedObject(keyToDelete.getKey()));
                }
                catch (OMException ex) {
                    if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                        result.addError(new MultiDeleteResponse.Error(keyToDelete.getKey(), "PermissionDenied", ex.getMessage()));
                        continue;
                    }
                    if (ex.getResult() != OMException.ResultCodes.KEY_NOT_FOUND) {
                        result.addError(new MultiDeleteResponse.Error(keyToDelete.getKey(), "InternalError", ex.getMessage()));
                        continue;
                    }
                    if (request.isQuiet()) continue;
                    result.addDeleted(new MultiDeleteResponse.DeletedObject(keyToDelete.getKey()));
                }
                catch (Exception ex) {
                    result.addError(new MultiDeleteResponse.Error(keyToDelete.getKey(), "InternalError", ex.getMessage()));
                }
            }
        }
        return result;
    }

    public S3BucketAcl getAcl(String bucketName) throws OS3Exception, IOException {
        S3BucketAcl result = new S3BucketAcl();
        try {
            OzoneBucket bucket = this.getBucket(bucketName);
            OzoneVolume volume = this.getVolume();
            S3Owner owner = new S3Owner(volume.getOwner(), volume.getOwner());
            result.setOwner(owner);
            HashSet<S3BucketAcl.Grant> grantSet = new HashSet<S3BucketAcl.Grant>();
            for (OzoneAcl acl : bucket.getAcls()) {
                List<S3BucketAcl.Grant> grants = S3Acl.ozoneNativeAclToS3Acl(acl);
                grantSet.addAll(grants);
            }
            ArrayList<S3BucketAcl.Grant> grantList = new ArrayList<S3BucketAcl.Grant>();
            grantList.addAll(grantSet);
            result.setAclList(new S3BucketAcl.AccessControlList(grantList));
            return result;
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName);
            }
            LOG.error("Failed to get acl of Bucket " + bucketName, (Throwable)ex);
            throw S3ErrorTable.newError(S3ErrorTable.INTERNAL_ERROR, bucketName);
        }
    }

    public Response putAcl(String bucketName, HttpHeaders httpHeaders, InputStream body) throws IOException, OS3Exception {
        String grantReads = httpHeaders.getHeaderString("x-amz-grant-read");
        String grantWrites = httpHeaders.getHeaderString("x-amz-grant-write");
        String grantReadACP = httpHeaders.getHeaderString("x-amz-grant-read-acp");
        String grantWriteACP = httpHeaders.getHeaderString("x-amz-grant-write-acp");
        String grantFull = httpHeaders.getHeaderString("x-amz-grant-full-control");
        try {
            OzoneBucket bucket = this.getBucket(bucketName);
            OzoneVolume volume = this.getVolume();
            ArrayList<OzoneAcl> ozoneAclListOnBucket = new ArrayList<OzoneAcl>();
            ArrayList<OzoneAcl> ozoneAclListOnVolume = new ArrayList<OzoneAcl>();
            if (grantReads == null && grantWrites == null && grantReadACP == null && grantWriteACP == null && grantFull == null) {
                Object putBucketAclRequest = new PutBucketAclRequestUnmarshaller().readFrom((Class)null, (Type)null, (Annotation[])null, (MediaType)null, (MultivaluedMap)null, body);
                ozoneAclListOnBucket.addAll(S3Acl.s3AclToOzoneNativeAclOnBucket((S3BucketAcl)putBucketAclRequest));
                ozoneAclListOnVolume.addAll(S3Acl.s3AclToOzoneNativeAclOnVolume((S3BucketAcl)putBucketAclRequest));
            } else {
                if (grantReads != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantReads, S3Acl.ACLType.READ.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantReads, S3Acl.ACLType.READ.getValue()));
                }
                if (grantWrites != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantWrites, S3Acl.ACLType.WRITE.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantWrites, S3Acl.ACLType.WRITE.getValue()));
                }
                if (grantReadACP != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantReadACP, S3Acl.ACLType.READ_ACP.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantReadACP, S3Acl.ACLType.READ_ACP.getValue()));
                }
                if (grantWriteACP != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantWriteACP, S3Acl.ACLType.WRITE_ACP.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantWriteACP, S3Acl.ACLType.WRITE_ACP.getValue()));
                }
                if (grantFull != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantFull, S3Acl.ACLType.FULL_CONTROL.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantFull, S3Acl.ACLType.FULL_CONTROL.getValue()));
                }
            }
            bucket.setAcl(ozoneAclListOnBucket);
            List acls = bucket.getAcls();
            ArrayList aclsToRemoveOnVolume = new ArrayList();
            List currentAclsOnVolume = volume.getAcls();
            if (currentAclsOnVolume.size() > 0) {
                for (OzoneAcl acl : acls) {
                    if (acl.getAclScope() != OzoneAcl.AclScope.ACCESS) continue;
                    aclsToRemoveOnVolume.addAll(OzoneAclUtil.filterAclList((String)acl.getName(), (IAccessAuthorizer.ACLIdentityType)acl.getType(), (List)currentAclsOnVolume));
                }
                for (OzoneAcl acl : aclsToRemoveOnVolume) {
                    volume.removeAcl(acl);
                }
            }
            for (OzoneAcl acl : ozoneAclListOnVolume) {
                volume.addAcl(acl);
            }
        }
        catch (OMException exception) {
            LOG.error("Error in set ACL Request for bucket: {}", (Object)bucketName, (Object)exception);
            if (exception.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
            }
            if (exception.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName);
            }
            throw exception;
        }
        return Response.status((int)200).build();
    }

    private List<OzoneAcl> getAndConvertAclOnBucket(String value, String permission) throws OS3Exception {
        String[] subValues;
        ArrayList<OzoneAcl> ozoneAclList = new ArrayList<OzoneAcl>();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return ozoneAclList;
        }
        for (String acl : subValues = value.split(",")) {
            String[] part = acl.split("=");
            if (part.length != 2) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, acl);
            }
            S3Acl.ACLIdentityType type = S3Acl.ACLIdentityType.getTypeFromHeaderType(part[0]);
            if (type == null || !type.isSupported()) {
                LOG.warn("S3 grantee {} is null or not supported", (Object)part[0]);
                throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, part[0]);
            }
            BitSet aclsOnBucket = S3Acl.getOzoneAclOnBucketFromS3Permission(permission);
            OzoneAcl defaultOzoneAcl = new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, part[1], aclsOnBucket, OzoneAcl.AclScope.DEFAULT);
            OzoneAcl accessOzoneAcl = new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, part[1], aclsOnBucket, OzoneAcl.AclScope.ACCESS);
            ozoneAclList.add(defaultOzoneAcl);
            ozoneAclList.add(accessOzoneAcl);
        }
        return ozoneAclList;
    }

    private List<OzoneAcl> getAndConvertAclOnVolume(String value, String permission) throws OS3Exception {
        String[] subValues;
        ArrayList<OzoneAcl> ozoneAclList = new ArrayList<OzoneAcl>();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return ozoneAclList;
        }
        for (String acl : subValues = value.split(",")) {
            String[] part = acl.split("=");
            if (part.length != 2) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, acl);
            }
            S3Acl.ACLIdentityType type = S3Acl.ACLIdentityType.getTypeFromHeaderType(part[0]);
            if (type == null || !type.isSupported()) {
                LOG.warn("S3 grantee {} is null or not supported", (Object)part[0]);
                throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, part[0]);
            }
            BitSet aclsOnVolume = S3Acl.getOzoneAclOnVolumeFromS3Permission(permission);
            OzoneAcl accessOzoneAcl = new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, part[1], aclsOnVolume, OzoneAcl.AclScope.ACCESS);
            ozoneAclList.add(accessOzoneAcl);
        }
        return ozoneAclList;
    }

    private void addKey(ListObjectResponse response, OzoneKey next) {
        KeyMetadata keyMetadata = new KeyMetadata();
        keyMetadata.setKey(next.getName());
        keyMetadata.setSize(next.getDataSize());
        keyMetadata.setETag("" + next.getModificationTime());
        if (next.getReplicationType().toString().equals(ReplicationType.STAND_ALONE.toString())) {
            keyMetadata.setStorageClass(S3StorageType.REDUCED_REDUNDANCY.toString());
        } else {
            keyMetadata.setStorageClass(S3StorageType.STANDARD.toString());
        }
        keyMetadata.setLastModified(next.getModificationTime());
        response.addKey(keyMetadata);
    }
}

