/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.ozone.s3.signature.SignatureProcessor;
import org.apache.hadoop.ozone.s3.signature.StringToSignProducer;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class OzoneClientProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientProducer.class);
    private OzoneClient client;
    @Inject
    private SignatureProcessor signatureProcessor;
    @Inject
    private OzoneConfiguration ozoneConfiguration;
    @Inject
    private Text omService;
    @Inject
    private String omServiceID;
    @Context
    private ContainerRequestContext context;

    @Produces
    public OzoneClient createClient() throws WebApplicationException, IOException {
        this.client = this.getClient(this.ozoneConfiguration);
        return this.client;
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.client.close();
    }

    private OzoneClient getClient(OzoneConfiguration config) throws WebApplicationException {
        OzoneClient ozoneClient = null;
        try {
            SignatureInfo signatureInfo = this.signatureProcessor.parseSignature();
            String stringToSign = "";
            if (signatureInfo.getVersion() == SignatureInfo.Version.V4) {
                stringToSign = StringToSignProducer.createSignatureBase(signatureInfo, this.context);
            }
            String awsAccessId = signatureInfo.getAwsAccessId();
            this.validateAccessId(awsAccessId);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)awsAccessId);
            if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)config)) {
                LOG.debug("Creating s3 auth info for client.");
                if (signatureInfo.getVersion() == SignatureInfo.Version.NONE) {
                    throw S3ErrorTable.MALFORMED_HEADER;
                }
                OzoneTokenIdentifier identifier = new OzoneTokenIdentifier();
                identifier.setTokenType(OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO);
                identifier.setStrToSign(stringToSign);
                identifier.setSignature(signatureInfo.getSignature());
                identifier.setAwsAccessId(awsAccessId);
                identifier.setOwner(new Text(awsAccessId));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Adding token for service:{}", (Object)this.omService);
                }
                Token token = new Token(identifier.getBytes(), identifier.getSignature().getBytes(StandardCharsets.UTF_8), identifier.getKind(), this.omService);
                remoteUser.addToken(token);
            }
            ozoneClient = (OzoneClient)remoteUser.doAs(() -> this.createOzoneClient());
        }
        catch (OS3Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error during Client Creation: ", (Throwable)ex);
            }
            throw this.wrapOS3Exception(ex);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error during Client Creation: ", (Throwable)e);
            }
            throw this.wrapOS3Exception(S3ErrorTable.INTERNAL_ERROR);
        }
        return ozoneClient;
    }

    @NotNull
    @VisibleForTesting
    OzoneClient createOzoneClient() throws IOException {
        if (this.omServiceID == null) {
            return OzoneClientFactory.getRpcClient((ConfigurationSource)this.ozoneConfiguration);
        }
        return OzoneClientFactory.getRpcClient((String)this.omServiceID, (ConfigurationSource)this.ozoneConfiguration);
    }

    private void validateAccessId(String awsAccessId) throws Exception {
        if (awsAccessId == null || awsAccessId.equals("")) {
            LOG.error("Malformed s3 header. awsAccessID: ", (Object)awsAccessId);
            throw this.wrapOS3Exception(S3ErrorTable.MALFORMED_HEADER);
        }
    }

    public void setOzoneConfiguration(OzoneConfiguration config) {
        this.ozoneConfiguration = config;
    }

    @VisibleForTesting
    public void setSignatureParser(SignatureProcessor awsSignatureProcessor) {
        this.signatureProcessor = awsSignatureProcessor;
    }

    private WebApplicationException wrapOS3Exception(OS3Exception os3Exception) {
        return new WebApplicationException((Throwable)os3Exception, os3Exception.getHttpCode());
    }
}

