/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight;

import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.insight.BaseInsightSubCommand;
import org.apache.hadoop.ozone.insight.Component;
import org.apache.hadoop.ozone.insight.InsightPoint;
import picocli.CommandLine;

@CommandLine.Command(name="config", description={"Show configuration for a specific subcomponents"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ConfigurationSubCommand
extends BaseInsightSubCommand
implements Callable<Void> {
    @CommandLine.Parameters(description={"Name of the insight point (use list to check the available options)"})
    private String insightName;

    @Override
    public Void call() throws Exception {
        InsightPoint insight = this.getInsight(this.getInsightCommand().createOzoneConfiguration(), this.insightName);
        System.out.println("Configuration for `" + this.insightName + "` (" + insight.getDescription() + ")");
        System.out.println();
        Component.Type type = Component.Type.valueOf(this.insightName.split("\\.")[0].toUpperCase());
        for (Class clazz : insight.getConfigurationClasses()) {
            this.showConfig(clazz, type);
        }
        return null;
    }

    protected void showConfig(Class clazz, Component.Type type) {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.addResource(this.getHost(conf, new Component(type)) + "/conf");
        this.printConfig(clazz, conf);
    }

    protected void printConfig(Class clazz, OzoneConfiguration conf) {
        ConfigGroup configGroup = clazz.getAnnotation(ConfigGroup.class);
        if (configGroup == null) {
            return;
        }
        this.printConfig(configGroup, clazz, conf);
    }

    private void printConfig(ConfigGroup configGroup, Class clazz, OzoneConfiguration conf) {
        String prefix = configGroup.prefix();
        for (Field field : clazz.getDeclaredFields()) {
            Class superclass;
            if (field.isAnnotationPresent(Config.class)) {
                Config config = field.getAnnotation(Config.class);
                String key = prefix + "." + config.key();
                System.out.println(">>> " + key);
                System.out.println("       default: " + config.defaultValue());
                System.out.println("       current: " + conf.get(key));
                System.out.println();
                System.out.println(config.description());
                System.out.println();
                System.out.println();
            }
            if ((superclass = clazz.getSuperclass()) == Object.class) continue;
            this.printConfig(configGroup, superclass, conf);
        }
    }
}

