/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfigValidator;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="cp", description={"copies an existing key to another one within the same bucket"})
public class CopyKeyHandler
extends BucketHandler {
    @CommandLine.Parameters(index="1", arity="1..1", description={"The existing key to be renamed"})
    private String fromKey;
    @CommandLine.Parameters(index="2", arity="1..1", description={"The new desired name of the key"})
    private String toKey;
    @CommandLine.Option(names={"-r", "--replication"}, description={"Replication configuration of the new key. (this is replication specific. for RATIS/STANDALONE you can use ONE or THREE) Default is specified in the cluster-wide config."})
    private String replication;
    @CommandLine.Option(names={"-t", "--type"}, description={"Replication type of the new key. (use RATIS or STAND_ALONE) Default is specified in the cluster-wide config."})
    private ReplicationType replicationType;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        if (this.replicationType == null) {
            this.replicationType = ReplicationType.valueOf((String)this.getConf().get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT));
        }
        if (this.replication == null) {
            this.replication = this.getConf().get("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT);
        }
        ReplicationConfig replicationConfig = ((ReplicationConfigValidator)this.getConf().getObject(ReplicationConfigValidator.class)).validate(ReplicationConfig.fromTypeAndString((ReplicationType)this.replicationType, (String)this.replication));
        OzoneKeyDetails keyDetail = bucket.getKey(this.fromKey);
        HashMap<String, String> keyMetadata = new HashMap<String, String>(keyDetail.getMetadata());
        keyMetadata.remove("secret");
        keyMetadata.remove("algorithm");
        String gdprEnabled = (String)bucket.getMetadata().get("gdprEnabled");
        if (Boolean.parseBoolean(gdprEnabled)) {
            keyMetadata.put("gdprEnabled", Boolean.TRUE.toString());
        }
        int chunkSize = (int)this.getConf().getStorageSize("ozone.scm.chunk.size", "4MB", StorageUnit.BYTES);
        try (OzoneInputStream input = bucket.readKey(this.fromKey);
             OzoneOutputStream output = bucket.createKey(this.toKey, (long)input.available(), replicationConfig, keyMetadata);){
            IOUtils.copyBytes((InputStream)input, (OutputStream)output, (int)chunkSize);
        }
        if (this.isVerbose()) {
            this.out().printf("Copy Key : %s to %s%n", this.fromKey, this.toKey);
        }
    }
}

