/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public abstract class Handler
implements Callable<Void> {
    protected static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    private OzoneConfiguration conf;
    @CommandLine.ParentCommand
    private GenericParentCommand parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public boolean isVerbose() {
        return this.parent.isVerbose();
    }

    public OzoneConfiguration createOzoneConfiguration() {
        return this.parent.createOzoneConfiguration();
    }

    protected OzoneAddress getAddress() throws OzoneClientException {
        return new OzoneAddress();
    }

    protected abstract void execute(OzoneClient var1, OzoneAddress var2) throws IOException, OzoneClientException;

    protected boolean isApplicable() {
        return true;
    }

    @Override
    public Void call() throws Exception {
        this.conf = this.createOzoneConfiguration();
        if (!this.isApplicable()) {
            return null;
        }
        OzoneAddress address = this.getAddress();
        try (OzoneClient client = this.createClient(address);){
            if (this.isVerbose()) {
                address.print(this.out());
            }
            this.execute(client, address);
        }
        return null;
    }

    protected OzoneClient createClient(OzoneAddress address) throws IOException, OzoneClientException {
        return address.createClient((MutableConfigurationSource)this.conf);
    }

    protected boolean securityEnabled() {
        boolean enabled = OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.conf);
        if (!enabled) {
            this.err().printf("Error: '%s' operation works only when security is enabled. To enable security set ozone.security.enabled to true.%n", this.spec.qualifiedName());
        }
        return enabled;
    }

    protected void printObjectAsJson(Object o) throws IOException {
        this.out().println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)o));
    }

    protected void printMsg(String msg) {
        this.out().println(msg);
    }

    protected OzoneConfiguration getConf() {
        return this.conf;
    }

    protected PrintStream out() {
        return System.out;
    }

    protected PrintStream err() {
        return System.err;
    }
}

