/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.ozone.genesis.GenesisUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class BenchMarkSCM {
    private static String testDir;
    private static StorageContainerManager scm;
    private static BlockManager blockManager;
    private static ReentrantLock lock;
    @Param(value={"1", "10", "100", "1000", "10000", "100000"})
    private static int numPipelines;
    @Param(value={"3", "10", "100"})
    private static int numContainersPerPipeline;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Setup(value=Level.Trial)
    public static void initialize() throws Exception {
        try {
            lock.lock();
            if (scm == null) {
                OzoneConfiguration conf = new OzoneConfiguration();
                testDir = GenesisUtil.getTempPath().resolve(RandomStringUtils.randomNumeric((int)7)).toString();
                conf.set("ozone.metadata.dirs", testDir);
                GenesisUtil.configureSCM(conf, 10);
                conf.setInt("ozone.scm.pipeline.owner.container.count", numContainersPerPipeline);
                GenesisUtil.addPipelines(HddsProtos.ReplicationFactor.THREE, numPipelines, (ConfigurationSource)conf);
                scm = GenesisUtil.getScm(conf, new SCMConfigurator());
                scm.start();
                blockManager = scm.getScmBlockManager();
                PipelineManager pipelineManager = scm.getPipelineManager();
                for (Pipeline pipeline : pipelineManager.getPipelines((ReplicationConfig)new RatisReplicationConfig(HddsProtos.ReplicationFactor.THREE))) {
                    pipelineManager.openPipeline(pipeline.getId());
                }
                scm.getEventQueue().fireEvent((Event)SCMEvents.SAFE_MODE_STATUS, (Object)new SCMSafeModeManager.SafeModeStatus(false, false));
                Thread.sleep(1000L);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @TearDown(value=Level.Trial)
    public static void tearDown() {
        try {
            lock.lock();
            if (scm != null) {
                scm.stop();
                scm.join();
                scm = null;
                FileUtil.fullyDelete((File)new File(testDir));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Threads(value=4)
    @Benchmark
    public void allocateBlockBenchMark(BenchMarkSCM state, Blackhole bh) throws IOException {
        blockManager.allocateBlock(50L, (ReplicationConfig)new RatisReplicationConfig(HddsProtos.ReplicationFactor.THREE), "Genesis", new ExcludeList());
    }

    static {
        lock = new ReentrantLock();
    }
}

