/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.BucketManagerImpl;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.VolumeManagerImpl;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.security.UserGroupInformation;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class BenchMarkOMKeyAllocation {
    private static final String TMP_DIR = "java.io.tmpdir";
    private String volumeName = UUID.randomUUID().toString();
    private String bucketName = UUID.randomUUID().toString();
    private KeyManager keyManager;
    private VolumeManager volumeManager;
    private BucketManager bucketManager;
    private String path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(RandomStringUtils.randomNumeric((int)6)).toFile().getAbsolutePath();

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        OzoneConfiguration configuration = new OzoneConfiguration();
        configuration.set("ozone.om.db.dirs", this.path);
        OmMetadataManagerImpl omMetadataManager = new OmMetadataManagerImpl(configuration);
        this.volumeManager = new VolumeManagerImpl((OMMetadataManager)omMetadataManager, configuration);
        this.bucketManager = new BucketManagerImpl((OMMetadataManager)omMetadataManager);
        this.volumeManager.createVolume(new OmVolumeArgs.Builder().setVolume(this.volumeName).setAdminName(UserGroupInformation.getLoginUser().getUserName()).setOwnerName(UserGroupInformation.getLoginUser().getUserName()).build());
        this.bucketManager.createBucket(new OmBucketInfo.Builder().setBucketName(this.bucketName).setVolumeName(this.volumeName).build());
        this.keyManager = new KeyManagerImpl(null, (OMMetadataManager)omMetadataManager, configuration, UUID.randomUUID().toString(), null);
    }

    @TearDown(value=Level.Trial)
    public void cleanup() throws IOException {
        FileUtils.deleteDirectory((File)new File(this.path));
        this.keyManager.stop();
    }

    @Benchmark
    public void keyCreation() throws IOException {
        OzoneConfiguration configuration = new OzoneConfiguration();
        configuration.set("ozone.om.db.dirs", this.path);
        List<OmKeyLocationInfo> keyLocationInfos = this.getKeyInfoList();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(UUID.randomUUID().toString()).setDataSize(0L).setReplicationConfig((ReplicationConfig)new RatisReplicationConfig(HddsProtos.ReplicationFactor.THREE)).build();
        OpenKeySession openKeySession = this.keyManager.openKey(omKeyArgs);
        omKeyArgs.setLocationInfoList(keyLocationInfos);
        this.keyManager.commitKey(omKeyArgs, openKeySession.getId());
    }

    public List<OmKeyLocationInfo> getKeyInfoList() {
        ArrayList<OmKeyLocationInfo> omKeyLocationInfoList = new ArrayList<OmKeyLocationInfo>();
        omKeyLocationInfoList.add(this.getKeyInfo());
        omKeyLocationInfoList.add(this.getKeyInfo());
        return omKeyLocationInfoList;
    }

    public OmKeyLocationInfo getKeyInfo() {
        return new OmKeyLocationInfo.Builder().setBlockID(new BlockID(RandomUtils.nextLong((long)0L, (long)100000000L), RandomUtils.nextLong((long)0L, (long)10000000L))).setLength(RandomUtils.nextLong((long)0L, (long)10000000L)).setOffset(0L).build();
    }
}

