/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.impl.HddsDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Benchmark)
public class BenchMarkDatanodeDispatcher {
    private String baseDir;
    private String datanodeUuid;
    private HddsDispatcher dispatcher;
    private ByteString data;
    private Random random;
    private AtomicInteger containerCount;
    private AtomicInteger keyCount;
    private AtomicInteger chunkCount;
    private static final int INIT_CONTAINERS = 100;
    private static final int INIT_KEYS = 50;
    private static final int INIT_CHUNKS = 100;
    public static final int CHUNK_SIZE = 0x100000;
    private List<Long> containers;
    private List<Long> keys;
    private List<String> chunks;
    private MutableVolumeSet volumeSet;

    @Setup(value=Level.Trial)
    public void initialize() throws IOException {
        int x;
        this.datanodeUuid = UUID.randomUUID().toString();
        this.data = ByteString.copyFromUtf8((String)RandomStringUtils.randomAscii((int)0x100000));
        this.random = new Random();
        OzoneConfiguration conf = new OzoneConfiguration();
        this.baseDir = System.getProperty("java.io.tmpdir") + File.separator + this.datanodeUuid;
        conf.set("dfs.datanode.data.dir", this.baseDir + File.separator + "data");
        conf.set("ozone.scm.container.size", "10MB");
        ContainerSet containerSet = new ContainerSet();
        this.volumeSet = new MutableVolumeSet(this.datanodeUuid, (ConfigurationSource)conf, null, StorageVolume.VolumeType.DATA_VOLUME, null);
        StateContext context = new StateContext((ConfigurationSource)conf, DatanodeStateMachine.DatanodeStates.RUNNING, null);
        ContainerMetrics metrics = ContainerMetrics.create((ConfigurationSource)conf);
        HashMap handlers = Maps.newHashMap();
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            Handler handler = Handler.getHandlerForContainerType((ContainerProtos.ContainerType)containerType, (ConfigurationSource)conf, (String)"datanodeid", (ContainerSet)containerSet, (VolumeSet)this.volumeSet, (ContainerMetrics)metrics, c -> {});
            handler.setClusterID("scm");
            handlers.put(containerType, handler);
        }
        this.dispatcher = new HddsDispatcher((ConfigurationSource)conf, containerSet, (VolumeSet)this.volumeSet, (Map)handlers, context, metrics, null);
        this.dispatcher.init();
        this.containerCount = new AtomicInteger();
        this.keyCount = new AtomicInteger();
        this.chunkCount = new AtomicInteger();
        this.containers = new ArrayList<Long>();
        this.keys = new ArrayList<Long>();
        this.chunks = new ArrayList<String>();
        for (x = 0; x < 100; ++x) {
            long containerID = HddsUtils.getTime() + (long)x;
            ContainerProtos.ContainerCommandRequestProto req = this.getCreateContainerCommand(containerID);
            this.dispatcher.dispatch(req, null);
            this.containers.add(containerID);
            this.containerCount.getAndIncrement();
        }
        for (x = 0; x < 50; ++x) {
            this.keys.add(HddsUtils.getTime() + (long)x);
        }
        for (x = 0; x < 100; ++x) {
            this.chunks.add("chunk-" + x);
        }
        for (x = 0; x < 50; ++x) {
            String chunkName = this.chunks.get(x);
            this.chunkCount.getAndIncrement();
            long key = this.keys.get(x);
            this.keyCount.getAndIncrement();
            for (int y = 0; y < 100; ++y) {
                long containerID = this.containers.get(y);
                BlockID blockID = new BlockID(containerID, key);
                this.dispatcher.dispatch(this.getPutBlockCommand(blockID, chunkName), null);
                this.dispatcher.dispatch(this.getWriteChunkCommand(blockID, chunkName), null);
            }
        }
    }

    @TearDown(value=Level.Trial)
    public void cleanup() throws IOException {
        this.volumeSet.shutdown();
        FileUtils.deleteDirectory((File)new File(this.baseDir));
    }

    private ContainerProtos.ContainerCommandRequestProto getCreateContainerCommand(long containerID) {
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.CreateContainer);
        request.setContainerID(containerID);
        request.setCreateContainer(ContainerProtos.CreateContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(this.datanodeUuid);
        request.setTraceID(containerID + "-trace");
        return request.build();
    }

    private ContainerProtos.ContainerCommandRequestProto getWriteChunkCommand(BlockID blockID, String chunkName) {
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(this.getChunkInfo(blockID, chunkName)).setData(this.data);
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setTraceID(this.getBlockTraceID(blockID)).setDatanodeUuid(this.datanodeUuid).setWriteChunk(writeChunkRequest);
        return request.build();
    }

    private ContainerProtos.ContainerCommandRequestProto getReadChunkCommand(BlockID blockID, String chunkName) {
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(this.getChunkInfo(blockID, chunkName)).setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1);
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockID.getContainerID()).setTraceID(this.getBlockTraceID(blockID)).setDatanodeUuid(this.datanodeUuid).setReadChunk(readChunkRequest);
        return request.build();
    }

    private ContainerProtos.ChunkInfo getChunkInfo(BlockID blockID, String chunkName) {
        ContainerProtos.ChunkInfo.Builder builder = ContainerProtos.ChunkInfo.newBuilder().setChunkName(DigestUtils.md5Hex((String)chunkName) + "_stream_" + blockID.getContainerID() + "_block_" + blockID.getLocalID()).setChecksumData(ContainerProtos.ChecksumData.newBuilder().setBytesPerChecksum(4).setType(ContainerProtos.ChecksumType.CRC32).build()).setOffset(0L).setLen((long)this.data.size());
        return builder.build();
    }

    private ContainerProtos.ContainerCommandRequestProto getPutBlockCommand(BlockID blockID, String chunkKey) {
        ContainerProtos.PutBlockRequestProto.Builder putBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(this.getBlockData(blockID, chunkKey));
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.PutBlock).setContainerID(blockID.getContainerID()).setTraceID(this.getBlockTraceID(blockID)).setDatanodeUuid(this.datanodeUuid).setPutBlock(putBlockRequest);
        return request.build();
    }

    private ContainerProtos.ContainerCommandRequestProto getGetBlockCommand(BlockID blockID) {
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(blockID.getContainerID()).setTraceID(this.getBlockTraceID(blockID)).setDatanodeUuid(this.datanodeUuid).setGetBlock(readBlockRequest);
        return request.build();
    }

    private ContainerProtos.BlockData getBlockData(BlockID blockID, String chunkKey) {
        ContainerProtos.BlockData.Builder builder = ContainerProtos.BlockData.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).addChunks(this.getChunkInfo(blockID, chunkKey));
        return builder.build();
    }

    @Benchmark
    public void createContainer(BenchMarkDatanodeDispatcher bmdd) {
        long containerID = RandomUtils.nextLong();
        ContainerProtos.ContainerCommandRequestProto req = this.getCreateContainerCommand(containerID);
        bmdd.dispatcher.dispatch(req, null);
        bmdd.containers.add(containerID);
        bmdd.containerCount.getAndIncrement();
    }

    @Benchmark
    public void writeChunk(BenchMarkDatanodeDispatcher bmdd) {
        bmdd.dispatcher.dispatch(this.getWriteChunkCommand(this.getRandomBlockID(), this.getNewChunkToWrite()), null);
    }

    @Benchmark
    public void readChunk(BenchMarkDatanodeDispatcher bmdd) {
        BlockID blockID = this.getRandomBlockID();
        String chunkKey = this.getRandomChunkToRead();
        bmdd.dispatcher.dispatch(this.getReadChunkCommand(blockID, chunkKey), null);
    }

    @Benchmark
    public void putBlock(BenchMarkDatanodeDispatcher bmdd) {
        BlockID blockID = this.getRandomBlockID();
        String chunkKey = this.getNewChunkToWrite();
        bmdd.dispatcher.dispatch(this.getPutBlockCommand(blockID, chunkKey), null);
    }

    @Benchmark
    public void getBlock(BenchMarkDatanodeDispatcher bmdd) {
        BlockID blockID = this.getRandomBlockID();
        bmdd.dispatcher.dispatch(this.getGetBlockCommand(blockID), null);
    }

    private BlockID getRandomBlockID() {
        return new BlockID(this.getRandomContainerID(), this.getRandomKeyID());
    }

    private long getRandomContainerID() {
        return this.containers.get(this.random.nextInt(100));
    }

    private long getRandomKeyID() {
        return this.keys.get(this.random.nextInt(50));
    }

    private String getRandomChunkToRead() {
        return this.chunks.get(this.random.nextInt(100));
    }

    private String getNewChunkToWrite() {
        return "chunk-" + this.chunkCount.getAndIncrement();
    }

    private String getBlockTraceID(BlockID blockID) {
        return blockID.getContainerID() + "-" + blockID.getLocalID() + "-trace";
    }
}

