/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.util.NativeCRC32Wrapper;
import org.openjdk.jmh.Main;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

public class BenchMarkCRCBatch {
    private static int dataSize = 0x4000000;

    @Benchmark
    @Threads(value=1)
    @Warmup(iterations=3, time=1000, timeUnit=TimeUnit.MILLISECONDS)
    @Fork(value=1, warmups=0)
    @Measurement(iterations=5, time=2000, timeUnit=TimeUnit.MILLISECONDS)
    @BenchmarkMode(value={Mode.Throughput})
    public void runCRCNativeBatch(Blackhole blackhole, BenchmarkState state) {
        if (!state.crcImpl.equals("nativeCRC32") && !state.crcImpl.equals("nativeCRC32C")) {
            throw new RuntimeException("Batch mode not available for " + state.crcImpl);
        }
        NativeCRC32Wrapper.calculateChunkedSumsByteArray((int)state.checksumSize, (int)state.nativeChecksumType, (byte[])state.checksumBuffer, (int)0, (byte[])state.data.array(), (int)0, (int)state.data.capacity());
        blackhole.consume((Object)state.checksumBuffer);
    }

    public static void main(String[] args) throws Exception {
        Main.main((String[])args);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkState {
        private final ByteBuffer data = ByteBuffer.allocate(BenchMarkCRCBatch.access$000());
        @Param(value={"512", "1024", "2048", "4096", "32768", "1048576"})
        private int checksumSize;
        @Param(value={"nativeCRC32", "nativeCRC32C"})
        private String crcImpl;
        private byte[] checksumBuffer;
        private int nativeChecksumType = 1;

        public ByteBuffer data() {
            return this.data;
        }

        public int checksumSize() {
            return this.checksumSize;
        }

        public String crcImpl() {
            return this.crcImpl;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The intent is to expose this variable")
        public byte[] checksumBuffer() {
            return this.checksumBuffer;
        }

        public int nativeChecksumType() {
            return this.nativeChecksumType;
        }

        @Setup(value=Level.Trial)
        public void setUp() {
            switch (this.crcImpl) {
                case "nativeCRC32": {
                    if (NativeCRC32Wrapper.isAvailable()) {
                        this.nativeChecksumType = 1;
                        this.checksumBuffer = new byte[4 * dataSize / this.checksumSize];
                        break;
                    }
                    throw new RuntimeException("Native library is not available");
                }
                case "nativeCRC32C": {
                    if (NativeCRC32Wrapper.isAvailable()) {
                        this.nativeChecksumType = 2;
                        this.checksumBuffer = new byte[4 * dataSize / this.checksumSize];
                        break;
                    }
                    throw new RuntimeException("Native library is not available");
                }
            }
            this.data.put(RandomUtils.nextBytes((int)this.data.remaining()));
        }
    }
}

