/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon.containergenerator;

import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RocksDBConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.freon.containergenerator.BaseGenerator;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.hadoop.util.Time;
import picocli.CommandLine;

@CommandLine.Command(name="cgom", description={"Offline container metadata generator for Ozone Manager"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class GeneratorOm
extends BaseGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="bucket1")
    private String bucketName;
    private DBStore omDb;
    private Table<String, OmKeyInfo> omKeyTable;
    private Timer timer;
    private OzoneConfiguration config;

    @Override
    public Void call() throws Exception {
        this.init();
        this.setThreadNo(1);
        this.config = this.createOzoneConfiguration();
        File metaDir = OMStorage.getOmDbDir((ConfigurationSource)this.config);
        RocksDBConfiguration rocksDBConfiguration = (RocksDBConfiguration)this.config.getObject(RocksDBConfiguration.class);
        DBStoreBuilder dbStoreBuilder = DBStoreBuilder.newBuilder((ConfigurationSource)this.config, (RocksDBConfiguration)rocksDBConfiguration).setName("om.db").setPath(metaDir.toPath());
        OmMetadataManagerImpl.addOMTablesAndCodecs((DBStoreBuilder)dbStoreBuilder);
        this.omDb = dbStoreBuilder.build();
        this.writeOmBucketVolume();
        this.omKeyTable = this.omDb.getTable("keyTable", String.class, OmKeyInfo.class);
        this.timer = this.getMetrics().timer("om-generator");
        this.runTests(this::writeOmKeys);
        this.omDb.close();
        return null;
    }

    public void writeOmKeys(long index) throws Exception {
        this.timer.time(() -> {
            long containerId = this.getContainerIdOffset() + index;
            int keyPerContainer = this.getKeysPerContainer((ConfigurationSource)this.config);
            BatchOperation omKeyTableBatchOperation = this.omDb.initBatchOperation();
            for (long localId = 0L; localId < (long)keyPerContainer; ++localId) {
                BlockID blockId = new BlockID(containerId, localId);
                this.writeOmData(localId, blockId, omKeyTableBatchOperation);
            }
            this.commitAndResetOMKeyTableBatchOperation(omKeyTableBatchOperation);
            return null;
        });
    }

    private void writeOmBucketVolume() throws IOException {
        Table volTable = this.omDb.getTable("volumeTable", String.class, OmVolumeArgs.class);
        String admin = GeneratorOm.getUserId();
        String owner = GeneratorOm.getUserId();
        OmVolumeArgs omVolumeArgs = new OmVolumeArgs.Builder().setVolume(this.volumeName).setAdminName(admin).setCreationTime(Time.now()).setOwnerName(owner).setObjectID(1L).setUpdateID(1L).setQuotaInBytes(100L).addOzoneAcls(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.WORLD, "", IAccessAuthorizer.ACLType.ALL, OzoneAcl.AclScope.ACCESS)).addOzoneAcls(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, GeneratorOm.getUserId(), IAccessAuthorizer.ACLType.ALL, OzoneAcl.AclScope.ACCESS)).build();
        volTable.put((Object)("/" + this.volumeName), (Object)omVolumeArgs);
        Table userTable = this.omDb.getTable("userTable", String.class, OzoneManagerStorageProtos.PersistedUserVolumeInfo.class);
        OzoneManagerStorageProtos.PersistedUserVolumeInfo currentUserVolumeInfo = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)userTable.get((Object)GeneratorOm.getUserId());
        if (currentUserVolumeInfo == null) {
            currentUserVolumeInfo = OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().addVolumeNames(this.volumeName).build();
        } else if (!currentUserVolumeInfo.getVolumeNamesList().contains(this.volumeName)) {
            currentUserVolumeInfo = OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().addAllVolumeNames((Iterable)currentUserVolumeInfo.getVolumeNamesList()).addVolumeNames(this.volumeName).build();
        }
        userTable.put((Object)GeneratorOm.getUserId(), (Object)currentUserVolumeInfo);
        Table bucketTable = this.omDb.getTable("bucketTable", String.class, OmBucketInfo.class);
        OmBucketInfo omBucketInfo = new OmBucketInfo.Builder().setBucketName(this.bucketName).setVolumeName(this.volumeName).build();
        bucketTable.put((Object)("/" + this.volumeName + "/" + this.bucketName), (Object)omBucketInfo);
    }

    private void addDirectoryKey(String keyName, BatchOperation omKeyTableBatchOperation) throws IOException {
        OmKeyInfo l3DirInfo = new OmKeyInfo.Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(keyName).setDataSize(0L).setCreationTime(System.currentTimeMillis()).setModificationTime(System.currentTimeMillis()).setReplicationConfig((ReplicationConfig)new RatisReplicationConfig(HddsProtos.ReplicationFactor.ONE)).build();
        this.omKeyTable.putWithBatch(omKeyTableBatchOperation, (Object)("/" + this.volumeName + "/" + this.bucketName + "/" + keyName), (Object)l3DirInfo);
    }

    private void writeOmData(long l, BlockID blockId, BatchOperation omKeyTableBatchOperation) throws IOException {
        ArrayList<OmKeyLocationInfo> omkl = new ArrayList<OmKeyLocationInfo>();
        omkl.add(new OmKeyLocationInfo.Builder().setBlockID(blockId).setLength((long)this.getKeySize()).setOffset(0L).build());
        OmKeyLocationInfoGroup infoGroup = new OmKeyLocationInfoGroup(0L, omkl);
        long l4n = l % 1000L;
        long l3n = l / 1000L % 1000L;
        long l2n = l / 1000000L % 1000L;
        long l1n = l / 1000000000L % 1000L;
        String level3 = "L3-" + l3n;
        String level2 = "L2-" + l2n;
        String level1 = "L1-" + l1n;
        if (l2n == 0L && l3n == 0L && l4n == 0L) {
            this.addDirectoryKey(level1 + "/", omKeyTableBatchOperation);
        }
        if (l3n == 0L && l4n == 0L) {
            this.addDirectoryKey(level1 + "/" + level2 + "/", omKeyTableBatchOperation);
        }
        if (l4n == 0L) {
            this.addDirectoryKey(level1 + "/" + level2 + "/" + level3 + "/", omKeyTableBatchOperation);
        }
        String keyName = "/vol1/bucket1/" + level1 + "/" + level2 + "/" + level3 + "/key" + l;
        OmKeyInfo keyInfo = new OmKeyInfo.Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(level1 + "/" + level2 + "/" + level3 + "/key" + l).setDataSize((long)this.getKeySize()).setCreationTime(System.currentTimeMillis()).setModificationTime(System.currentTimeMillis()).setReplicationConfig((ReplicationConfig)new StandaloneReplicationConfig(HddsProtos.ReplicationFactor.THREE)).addOmKeyLocationInfoGroup(infoGroup).build();
        this.omKeyTable.putWithBatch(omKeyTableBatchOperation, (Object)keyName, (Object)keyInfo);
    }

    private void commitAndResetOMKeyTableBatchOperation(BatchOperation omKeyTableBatchOperation) throws IOException {
        this.omDb.commitBatchOperation(omKeyTableBatchOperation);
        omKeyTableBatchOperation.close();
    }
}

