/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="ockr", aliases={"ozone-client-key-remover"}, description={"Remove keys with the help of the ozone clients."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OzoneClientKeyRemover
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    private Timer timer;
    private OzoneBucket ozoneBucket;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        try (OzoneClient rpcClient = this.createOzoneClient(this.omServiceID, ozoneConfiguration);){
            this.ozoneBucket = rpcClient.getObjectStore().getVolume(this.volumeName).getBucket(this.bucketName);
            this.timer = this.getMetrics().timer("remove");
            this.runTests(this::removeKey);
        }
        return null;
    }

    private void removeKey(long counter) throws Exception {
        String key = this.generateObjectName(counter);
        this.timer.time(() -> {
            this.ozoneBucket.deleteKey(key);
            return null;
        });
    }
}

