/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="ockg", aliases={"ozone-client-key-generator"}, description={"Generate keys with the help of the ozone clients."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OzoneClientKeyGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated key (in bytes)"}, defaultValue="10240")
    private long keySize;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used to generated the key content."}, defaultValue="4096")
    private int bufferSize;
    @CommandLine.Option(names={"-F", "--factor"}, description={"Replication factor (ONE, THREE)"}, defaultValue="THREE")
    private ReplicationFactor factor = ReplicationFactor.THREE;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    private Timer timer;
    private OzoneBucket bucket;
    private ContentGenerator contentGenerator;
    private Map<String, String> metadata;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        this.contentGenerator = new ContentGenerator(this.keySize, this.bufferSize);
        this.metadata = new HashMap<String, String>();
        try (OzoneClient rpcClient = this.createOzoneClient(this.omServiceID, ozoneConfiguration);){
            this.ensureVolumeAndBucketExist(rpcClient, this.volumeName, this.bucketName);
            this.bucket = rpcClient.getObjectStore().getVolume(this.volumeName).getBucket(this.bucketName);
            this.timer = this.getMetrics().timer("key-create");
            this.runTests(this::createKey);
        }
        return null;
    }

    private void createKey(long counter) throws Exception {
        String key = this.generateObjectName(counter);
        this.timer.time(() -> {
            try (OzoneOutputStream stream = this.bucket.createKey(key, this.keySize, ReplicationType.RATIS, this.factor, this.metadata);){
                this.contentGenerator.write((OutputStream)stream);
                stream.flush();
            }
            return null;
        });
    }
}

