/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dcv", aliases={"datanode-chunk-validator"}, description={"Validate generated Chunks are the same "}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class DatanodeChunkValidator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeChunkValidator.class);
    @CommandLine.Option(names={"-l", "--pipeline"}, description={"Pipeline to use. By default the first RATIS/THREE pipeline will be used."}, defaultValue="")
    private String pipelineId;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated chunks (in bytes)"}, defaultValue="1024")
    private int chunkSize;
    private XceiverClientSpi xceiverClientSpi;
    private Timer timer;
    private ChecksumData checksumReference;
    private Checksum checksum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConf = this.createOzoneConfiguration();
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)ozoneConf)) {
            throw new IllegalArgumentException("Datanode chunk validator is not supported in secure environment");
        }
        try (StorageContainerLocationProtocol scmLocationClient = this.createStorageContainerLocationClient(ozoneConf);){
            Pipeline pipeline;
            List pipelines = scmLocationClient.listPipelines();
            if (this.pipelineId != null && this.pipelineId.length() > 0) {
                pipeline = pipelines.stream().filter(p -> p.getId().toString().equals(this.pipelineId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Pipeline ID is defined, but there is no such pipeline: " + this.pipelineId));
            } else {
                pipeline = pipelines.stream().filter(p -> ReplicationConfig.getLegacyFactor((ReplicationConfig)p.getReplicationConfig()) == HddsProtos.ReplicationFactor.THREE).findFirst().orElseThrow(() -> new IllegalArgumentException("Pipeline ID is NOT defined, and no pipeline has been found with factor=THREE"));
                LOG.info("Using pipeline {}", (Object)pipeline.getId());
            }
            try (XceiverClientManager xceiverClientManager = new XceiverClientManager((ConfigurationSource)ozoneConf);){
                this.xceiverClientSpi = xceiverClientManager.acquireClient(pipeline);
                this.readReference();
                this.timer = this.getMetrics().timer("chunk-validate");
                this.runTests(this::validateChunk);
            }
        }
        finally {
            if (this.xceiverClientSpi != null) {
                this.xceiverClientSpi.close();
            }
        }
        return null;
    }

    private void readReference() throws IOException {
        ContainerProtos.DatanodeBlockID blockId = ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(1L).setLocalID(0L).setBlockCommitSequenceId(0L).build();
        ContainerProtos.ChunkInfo chunkInfo = ContainerProtos.ChunkInfo.newBuilder().setChunkName(this.getPrefix() + "_testdata_chunk_" + 0).setOffset((long)(0 * this.chunkSize)).setLen((long)this.chunkSize).setChecksumData(ContainerProtos.ChecksumData.newBuilder().setBytesPerChecksum(4).setType(ContainerProtos.ChecksumType.CRC32).build()).build();
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockId).setChunkData(chunkInfo);
        String id = this.xceiverClientSpi.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockId.getContainerID()).setDatanodeUuid(id).setReadChunk(readChunkRequest);
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = this.xceiverClientSpi.sendCommand(request);
        this.checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, this.chunkSize);
        this.checksumReference = response.getReadChunk().hasData() ? this.checksum.computeChecksum(response.getReadChunk().getData().toByteArray()) : this.checksum.computeChecksum(response.getReadChunk().getDataBuffers().getBuffersList());
    }

    private void validateChunk(long stepNo) throws Exception {
        ContainerProtos.DatanodeBlockID blockId = ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(1L).setLocalID(stepNo % 20L).setBlockCommitSequenceId(stepNo).build();
        ContainerProtos.ChunkInfo chunkInfo = ContainerProtos.ChunkInfo.newBuilder().setChunkName(this.getPrefix() + "_testdata_chunk_" + stepNo).setChecksumData(ContainerProtos.ChecksumData.newBuilder().setBytesPerChecksum(4).setType(ContainerProtos.ChecksumType.CRC32).build()).setOffset(stepNo / 20L * (long)this.chunkSize).setLen((long)this.chunkSize).build();
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockId).setChunkData(chunkInfo);
        String id = this.xceiverClientSpi.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockId.getContainerID()).setDatanodeUuid(id).setReadChunk(readChunkRequest);
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        this.timer.time(() -> {
            try {
                ContainerProtos.ContainerCommandResponseProto response = this.xceiverClientSpi.sendCommand(request);
                ChecksumData checksumOfChunk = response.getReadChunk().hasData() ? this.checksum.computeChecksum(response.getReadChunk().getData().toByteArray()) : this.checksum.computeChecksum(response.getReadChunk().getDataBuffers().getBuffersList());
                if (!this.checksumReference.equals((Object)checksumOfChunk)) {
                    throw new IllegalStateException("Reference (=first) message checksum doesn't match with checksum of chunk " + response.getReadChunk().getChunkData().getChunkName());
                }
            }
            catch (IOException e) {
                LOG.warn("Could not read chunk due to IOException: ", (Throwable)e);
            }
        });
    }
}

