/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.replication.ContainerDownloader;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.DownloadAndImportReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.apache.hadoop.ozone.container.replication.SimpleContainerDownloader;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="cr", aliases={"container-replicator"}, description={"Replicate / download closed containers."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class ClosedContainerReplicator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"--datanode"}, description={"Replicate only containers on this specific datanode."}, defaultValue="")
    private String datanode;
    private ReplicationSupervisor supervisor;
    private Timer timer;
    private List<ReplicationTask> replicationTasks;

    @Override
    public Void call() throws Exception {
        OzoneConfiguration conf = this.createOzoneConfiguration();
        Collection datanodeStorageDirs = HddsServerUtil.getDatanodeStorageDirs((ConfigurationSource)conf);
        for (String dir : datanodeStorageDirs) {
            this.checkDestinationDirectory(dir);
        }
        this.initializeReplicationSupervisor((ConfigurationSource)conf);
        ContainerOperationClient containerOperationClient = new ContainerOperationClient(conf);
        List containerInfos = containerOperationClient.listContainer(0L, 1000000);
        this.replicationTasks = new ArrayList<ReplicationTask>();
        for (ContainerInfo container : containerInfos) {
            ContainerWithPipeline containerWithPipeline = containerOperationClient.getContainerWithPipeline(container.getContainerID());
            if (container.getState() != HddsProtos.LifeCycleState.CLOSED) continue;
            List datanodesWithContainer = containerWithPipeline.getPipeline().getNodes();
            List datanodeUUIDs = datanodesWithContainer.stream().map(DatanodeDetails::getUuidString).collect(Collectors.toList());
            if (!this.datanode.isEmpty() && !datanodeUUIDs.contains(this.datanode)) continue;
            this.replicationTasks.add(new ReplicationTask(container.getContainerID(), datanodesWithContainer));
        }
        this.setTestNo(this.replicationTasks.size());
        this.init();
        this.timer = this.getMetrics().timer("replicate-container");
        this.runTests(this::replicateContainer);
        return null;
    }

    private void checkDestinationDirectory(String dirUrl) throws IOException {
        StorageLocation storageLocation = StorageLocation.parse((String)dirUrl);
        Path dirPath = Paths.get(storageLocation.getUri().getPath(), new String[0]);
        if (Files.notExists(dirPath, new LinkOption[0])) {
            return;
        }
        if (Files.list(dirPath).count() == 0L) {
            return;
        }
        throw new IllegalArgumentException("Configured storage directory " + dirUrl + " (used as destination) should be empty");
    }

    @NotNull
    private void initializeReplicationSupervisor(ConfigurationSource conf) throws IOException {
        String fakeDatanodeUuid = this.datanode;
        if (fakeDatanodeUuid.isEmpty()) {
            fakeDatanodeUuid = UUID.randomUUID().toString();
        }
        ContainerSet containerSet = new ContainerSet();
        ContainerMetrics metrics = ContainerMetrics.create((ConfigurationSource)conf);
        MutableVolumeSet volumeSet = new MutableVolumeSet(fakeDatanodeUuid, conf, null, StorageVolume.VolumeType.DATA_VOLUME, null);
        HashMap<ContainerProtos.ContainerType, Handler> handlers = new HashMap<ContainerProtos.ContainerType, Handler>();
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            Handler handler = Handler.getHandlerForContainerType((ContainerProtos.ContainerType)containerType, (ConfigurationSource)conf, (String)fakeDatanodeUuid, (ContainerSet)containerSet, (VolumeSet)volumeSet, (ContainerMetrics)metrics, containerReplicaProto -> {});
            handler.setClusterID(UUID.randomUUID().toString());
            handlers.put(containerType, handler);
        }
        ContainerController controller = new ContainerController(containerSet, handlers);
        DownloadAndImportReplicator replicator = new DownloadAndImportReplicator(containerSet, controller, (ContainerDownloader)new SimpleContainerDownloader(conf, null), new TarContainerPacker());
        this.supervisor = new ReplicationSupervisor(containerSet, (ContainerReplicator)replicator, 10);
    }

    private void replicateContainer(long counter) throws Exception {
        this.timer.time(() -> {
            ReplicationTask replicationTask = this.replicationTasks.get((int)counter);
            ReplicationSupervisor replicationSupervisor = this.supervisor;
            replicationSupervisor.getClass();
            new ReplicationSupervisor.TaskRunner(replicationSupervisor, replicationTask).run();
            return null;
        });
    }
}

