/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.container;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.hadoop.ozone.debug.container.ContainerCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export one container to a tarball"})
public class ExportSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ExportSubcommand.class);
    @CommandLine.ParentCommand
    private ContainerCommands parent;
    @CommandLine.Option(names={"--container"}, required=true, description={"Container Id"})
    private long containerId;
    @CommandLine.Option(names={"--dest"}, defaultValue="/tmp", description={"Destination directory"})
    private String destination;

    @Override
    public Void call() throws Exception {
        this.parent.loadContainersFromVolumes();
        OnDemandContainerReplicationSource replicationSource = new OnDemandContainerReplicationSource(this.parent.getController());
        LOG.info("Starting to replication");
        replicationSource.prepare(this.containerId);
        LOG.info("Preparation is done");
        File destinationFile = new File(this.destination, "container-" + this.containerId + ".tar.gz");
        try (FileOutputStream fos = new FileOutputStream(destinationFile);){
            replicationSource.copyData(this.containerId, (OutputStream)fos);
        }
        LOG.info("Container is exported to {}", (Object)destinationFile);
        return null;
    }
}

