/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.ozone.debug.DBDefinitionFactory;
import org.apache.hadoop.ozone.debug.RDBParser;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import picocli.CommandLine;

@CommandLine.Command(name="scan", description={"Parse specified metadataTable"})
public class DBScanner
implements Callable<Void>,
SubcommandWithParent {
    @CommandLine.Option(names={"--column_family"}, required=true, description={"Table name"})
    private String tableName;
    @CommandLine.Option(names={"--with-keys"}, description={"List Key -> Value instead of just Value."}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private static boolean withKey;
    @CommandLine.Option(names={"--length", "-l"}, description={"Maximum number of items to list. If -1 dumps the entire table data"})
    private static int limit;
    @CommandLine.Option(names={"--out", "-o"}, description={"File to dump table scan data"})
    private static String fileName;
    @CommandLine.ParentCommand
    private RDBParser parent;
    private HashMap<String, DBColumnFamilyDefinition> columnFamilyMap;
    private List<Object> scannedObjects;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Object> displayTable(RocksIterator iterator, DBColumnFamilyDefinition dbColumnFamilyDefinition) throws IOException {
        ArrayList<Object> outputs = new ArrayList<Object>();
        iterator.seekToFirst();
        Writer fileWriter = null;
        PrintWriter printWriter = null;
        try {
            if (fileName != null) {
                fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8);
                printWriter = new PrintWriter(fileWriter);
            }
            while (iterator.isValid()) {
                Gson gson;
                StringBuilder result = new StringBuilder();
                if (withKey) {
                    Object key = dbColumnFamilyDefinition.getKeyCodec().fromPersistedFormat(iterator.key());
                    gson = new GsonBuilder().setPrettyPrinting().create();
                    result.append(gson.toJson(key));
                    result.append(" -> ");
                }
                Object o = dbColumnFamilyDefinition.getValueCodec().fromPersistedFormat(iterator.value());
                outputs.add(o);
                gson = new GsonBuilder().setPrettyPrinting().create();
                result.append(gson.toJson(o));
                if (fileName != null) {
                    printWriter.println(result);
                } else {
                    System.out.println(result.toString());
                }
                iterator.next();
                if (--limit != 0) continue;
                break;
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        return outputs;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public RDBParser getParent() {
        return this.parent;
    }

    public void setParent(RDBParser parent) {
        this.parent = parent;
    }

    public static void setLimit(int limit) {
        DBScanner.limit = limit;
    }

    public List<Object> getScannedObjects() {
        return this.scannedObjects;
    }

    public static void setFileName(String name) {
        fileName = name;
    }

    private static ColumnFamilyHandle getColumnFamilyHandle(byte[] name, List<ColumnFamilyHandle> columnFamilyHandles) {
        return columnFamilyHandles.stream().filter(handle -> {
            try {
                return Arrays.equals(handle.getName(), name);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).findAny().orElse(null);
    }

    private void constructColumnFamilyMap(DBDefinition dbDefinition) {
        DBColumnFamilyDefinition[] columnFamilyDefinitions;
        if (dbDefinition == null) {
            System.out.println("Incorrect Db Path");
            return;
        }
        this.columnFamilyMap = new HashMap();
        for (DBColumnFamilyDefinition definition : columnFamilyDefinitions = dbDefinition.getColumnFamilies()) {
            System.out.println("Added definition for table:" + definition.getTableName());
            this.columnFamilyMap.put(definition.getTableName(), definition);
        }
    }

    @Override
    public Void call() throws Exception {
        List<ColumnFamilyDescriptor> cfs = RocksDBUtils.getColumnFamilyDescriptors(this.parent.getDbPath());
        ArrayList<ColumnFamilyHandle> columnFamilyHandleList = new ArrayList<ColumnFamilyHandle>();
        RocksDB rocksDB = RocksDB.openReadOnly((String)this.parent.getDbPath(), cfs, columnFamilyHandleList);
        this.printAppropriateTable(columnFamilyHandleList, rocksDB, this.parent.getDbPath());
        return null;
    }

    private void printAppropriateTable(List<ColumnFamilyHandle> columnFamilyHandleList, RocksDB rocksDB, String dbPath) throws IOException {
        if (limit < 1 && limit != -1) {
            throw new IllegalArgumentException("List length should be a positive number. Only allowed negative number is -1 which is to dump entire table");
        }
        dbPath = this.removeTrailingSlashIfNeeded(dbPath);
        this.constructColumnFamilyMap(DBDefinitionFactory.getDefinition(Paths.get(dbPath, new String[0])));
        if (this.columnFamilyMap != null) {
            if (!this.columnFamilyMap.containsKey(this.tableName)) {
                System.out.print("Table with name:" + this.tableName + " does not exist");
            } else {
                DBColumnFamilyDefinition columnFamilyDefinition = this.columnFamilyMap.get(this.tableName);
                ColumnFamilyHandle columnFamilyHandle = DBScanner.getColumnFamilyHandle(columnFamilyDefinition.getTableName().getBytes(StandardCharsets.UTF_8), columnFamilyHandleList);
                if (columnFamilyHandle == null) {
                    throw new IllegalArgumentException("columnFamilyHandle is null");
                }
                RocksIterator iterator = rocksDB.newIterator(columnFamilyHandle);
                this.scannedObjects = DBScanner.displayTable(iterator, columnFamilyDefinition);
            }
        } else {
            System.out.println("Incorrect db Path");
        }
    }

    private String removeTrailingSlashIfNeeded(String dbPath) {
        if (dbPath.endsWith("/")) {
            dbPath = dbPath.substring(0, dbPath.length() - 1);
        }
        return dbPath;
    }

    public Class<?> getParentType() {
        return RDBParser.class;
    }

    static {
        limit = 100;
    }
}

