/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import com.amazonaws.services.kms.model.InvalidArnException;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaTwoDBDefinition;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.recon.scm.ReconSCMDBDefinition;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;

public final class DBDefinitionFactory {
    private static HashMap<String, DBDefinition> dbMap = new HashMap();

    private DBDefinitionFactory() {
    }

    public static DBDefinition getDefinition(String dbName) {
        if (dbMap.containsKey(dbName)) {
            return dbMap.get(dbName);
        }
        return DBDefinitionFactory.getReconDBDefinition(dbName);
    }

    public static DBDefinition getDefinition(Path dbPath) {
        Preconditions.checkNotNull((Object)dbPath, (Object)"Path is required to identify the used db scheme");
        Path fileName = dbPath.getFileName();
        if (fileName == null) {
            throw new InvalidArnException("Path is required to identify the used db scheme");
        }
        String dbName = fileName.toString();
        if (dbName.endsWith("-container.db")) {
            return new DatanodeSchemaTwoDBDefinition(dbPath.toAbsolutePath().toString());
        }
        return DBDefinitionFactory.getDefinition(dbName);
    }

    private static DBDefinition getReconDBDefinition(String dbName) {
        if (dbName.startsWith("recon-container-key.db")) {
            return new ReconDBDefinition(dbName);
        }
        if (dbName.startsWith("om.snapshot.db")) {
            return new OMDBDefinition();
        }
        return null;
    }

    static {
        Arrays.asList(new SCMDBDefinition(), new OMDBDefinition(), new ReconSCMDBDefinition()).forEach(dbDefinition -> dbMap.put(dbDefinition.getName(), (DBDefinition)dbDefinition));
    }
}

