/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.admin.scm.FinalizeUpgradeCommandUtil;
import org.apache.hadoop.ozone.admin.scm.ScmAdmin;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import picocli.CommandLine;

@CommandLine.Command(name="finalizeupgrade", description={"Finalize SCM Upgrade"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class FinalizeScmUpgradeSubcommand
extends ScmSubcommand {
    @CommandLine.ParentCommand
    private ScmAdmin parent;
    @CommandLine.Option(names={"--takeover"}, description={"Forces takeover of monitoring from another client, if finalization has already been started and did not finish yet."})
    private boolean force;

    public void execute(ScmClient scmClient) throws IOException {
        String upgradeClientID = "Upgrade-Client-" + UUID.randomUUID().toString();
        try {
            UpgradeFinalizer.StatusAndMessages finalizationResponse = scmClient.finalizeScmUpgrade(upgradeClientID);
            if (FinalizeUpgradeCommandUtil.isFinalized(finalizationResponse.status())) {
                System.out.println("Upgrade has already been finalized.");
                FinalizeUpgradeCommandUtil.emitExitMsg();
                return;
            }
            if (!FinalizeUpgradeCommandUtil.isStarting(finalizationResponse.status())) {
                System.err.println("Invalid response from Storage Container Manager.");
                System.err.println("Current finalization status is: " + finalizationResponse.status());
                throw new IOException("Exiting...");
            }
        }
        catch (UpgradeException e) {
            FinalizeUpgradeCommandUtil.handleInvalidRequestAfterInitiatingFinalization(this.force, e);
        }
        this.monitorAndWaitFinalization(scmClient, upgradeClientID);
    }

    private void monitorAndWaitFinalization(ScmClient client, String upgradeClientID) throws IOException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Void> monitor = exec.submit(new UpgradeMonitor(client, upgradeClientID, this.force));
        try {
            monitor.get();
            FinalizeUpgradeCommandUtil.emitFinishedMsg("Storage Container Manager");
        }
        catch (InterruptedException | CancellationException e) {
            FinalizeUpgradeCommandUtil.emitCancellationMsg("Storage Container Manager");
        }
        catch (ExecutionException e) {
            FinalizeUpgradeCommandUtil.emitGeneralErrorMsg();
            throw new IOException(e.getCause());
        }
        finally {
            exec.shutdown();
        }
    }

    private static class UpgradeMonitor
    implements Callable<Void> {
        private ScmClient client;
        private String upgradeClientID;
        private boolean force;

        UpgradeMonitor(ScmClient client, String upgradeClientID, boolean force) {
            this.client = client;
            this.upgradeClientID = upgradeClientID;
            this.force = force;
        }

        @Override
        public Void call() throws Exception {
            boolean finished = false;
            while (!finished) {
                UpgradeFinalizer.StatusAndMessages progress;
                block6: {
                    block5: {
                        Thread.sleep(500L);
                        progress = this.client.queryUpgradeFinalizationProgress(this.upgradeClientID, this.force, false);
                        if (FinalizeUpgradeCommandUtil.isFinalized(progress.status())) {
                            System.out.println("Finalization already finished.");
                            FinalizeUpgradeCommandUtil.emitExitMsg();
                            return null;
                        }
                        if (FinalizeUpgradeCommandUtil.isInprogress(progress.status())) break block5;
                        if (!FinalizeUpgradeCommandUtil.isDone(progress.status())) break block6;
                    }
                    progress.msgs().stream().forEachOrdered(System.out::println);
                }
                if (!FinalizeUpgradeCommandUtil.isDone(progress.status())) continue;
                FinalizeUpgradeCommandUtil.emitExitMsg();
                finished = true;
            }
            return null;
        }
    }
}

