/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.cli.OzoneAdmin;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.admin.om.CancelPrepareSubCommand;
import org.apache.hadoop.ozone.admin.om.FinalizationStatusSubCommand;
import org.apache.hadoop.ozone.admin.om.FinalizeUpgradeSubCommand;
import org.apache.hadoop.ozone.admin.om.GetServiceRolesSubcommand;
import org.apache.hadoop.ozone.admin.om.PrepareSubCommand;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.protocol.ClientId;
import picocli.CommandLine;

@CommandLine.Command(name="om", description={"Ozone Manager specific admin operations"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={FinalizeUpgradeSubCommand.class, GetServiceRolesSubcommand.class, PrepareSubCommand.class, CancelPrepareSubCommand.class, FinalizationStatusSubCommand.class})
public class OMAdmin
extends GenericCli
implements SubcommandWithParent {
    @CommandLine.ParentCommand
    private OzoneAdmin parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public OzoneAdmin getParent() {
        return this.parent;
    }

    public Void call() throws Exception {
        GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
        return null;
    }

    public ClientProtocol createClient(String omServiceId) throws Exception {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        if (OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omServiceId)) {
            return OzoneClientFactory.getRpcClient((String)omServiceId, (ConfigurationSource)conf).getObjectStore().getClientProxy();
        }
        throw new OzoneClientException("This command works only on OzoneManager HA cluster. Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are " + conf.getTrimmedStringCollection("ozone.om.service.ids") + "\n");
    }

    public OzoneManagerProtocolClientSideTranslatorPB createOmClient(String omServiceID) throws Exception {
        return this.createOmClient(omServiceID, null, true);
    }

    public OzoneManagerProtocolClientSideTranslatorPB createOmClient(String omServiceID, String omHost, boolean forceHA) throws Exception {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        if (omHost != null && !omHost.isEmpty()) {
            omServiceID = null;
            conf.set("ozone.om.address", omHost);
        } else if (omServiceID == null || omServiceID.isEmpty()) {
            omServiceID = this.getTheOnlyConfiguredOmServiceIdOrThrow();
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        RPC.setProtocolEngine((Configuration)conf, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        String clientId = ClientId.randomId().toString();
        if (!forceHA || forceHA && OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omServiceID)) {
            OmTransport omTransport = new Hadoop3OmTransportFactory().createOmTransport((ConfigurationSource)conf, ugi, omServiceID);
            return new OzoneManagerProtocolClientSideTranslatorPB(omTransport, clientId);
        }
        throw new OzoneClientException("This command works only on OzoneManager HA cluster. Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are " + conf.getTrimmedStringCollection("ozone.om.service.ids") + "\n");
    }

    private String getTheOnlyConfiguredOmServiceIdOrThrow() {
        if (this.getConfiguredServiceIds().size() != 1) {
            throw new IllegalArgumentException("There is no Ozone Manager service IDspecified, but there are either zero, or more than one service configured. Please specify the service ID to be finalized.");
        }
        return this.getConfiguredServiceIds().iterator().next();
    }

    private Collection<String> getConfiguredServiceIds() {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        Collection omServiceIds = conf.getTrimmedStringCollection("ozone.om.service.ids");
        return omServiceIds;
    }

    public Class<?> getParentType() {
        return OzoneAdmin.class;
    }
}

