/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.nssummary;

import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryAdmin;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryCLIUtils;
import picocli.CommandLine;

@CommandLine.Command(name="quota", description={"Get quota usage for a path request."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class QuotaUsageSubCommand
implements Callable {
    @CommandLine.ParentCommand
    private NSSummaryAdmin parent;
    @CommandLine.Parameters(index="0", arity="0..1", description={"Non-empty path request without any protocol prefix."})
    private String path;
    private static final String ENDPOINT = "/api/v1/namespace/quota";
    private StringBuffer url = new StringBuffer();

    public Void call() throws Exception {
        if (this.path == null || this.path.length() == 0) {
            NSSummaryCLIUtils.printEmptyPathRequest();
            return null;
        }
        this.url.append(this.parent.getReconWebAddress()).append(ENDPOINT);
        NSSummaryCLIUtils.printNewLines(1);
        String response = NSSummaryCLIUtils.makeHttpCall(this.url, this.path, this.parent.isHTTPSEnabled(), this.parent.getOzoneConfig());
        if (response == null) {
            NSSummaryCLIUtils.printNewLines(1);
            return null;
        }
        HashMap<String, Object> quotaResponse = NSSummaryCLIUtils.getResponseMap(response);
        if (quotaResponse.get("status").equals("PATH_NOT_FOUND")) {
            NSSummaryCLIUtils.printPathNotFound();
        } else if (quotaResponse.get("status").equals("TYPE_NOT_APPLICABLE")) {
            NSSummaryCLIUtils.printTypeNA("Quota");
        } else {
            if (!this.parent.isFSOEnabled()) {
                NSSummaryCLIUtils.printFSOReminder();
            }
            NSSummaryCLIUtils.printWithUnderline("Quota", true);
            long quotaAllowed = (long)((Double)quotaResponse.get("allowed")).doubleValue();
            long quotaUsed = (long)((Double)quotaResponse.get("used")).doubleValue();
            NSSummaryCLIUtils.printSpaces(2);
            System.out.print("Allowed");
            NSSummaryCLIUtils.printKVSeparator();
            if (quotaAllowed != -1L) {
                System.out.println(FileUtils.byteCountToDisplaySize((long)quotaAllowed));
            } else {
                System.out.println("Quota not set");
            }
            NSSummaryCLIUtils.printSpaces(2);
            System.out.print("Used");
            NSSummaryCLIUtils.printKVSeparator();
            System.out.println(FileUtils.byteCountToDisplaySize((long)quotaUsed));
            NSSummaryCLIUtils.printSpaces(2);
            System.out.print("Remaining");
            NSSummaryCLIUtils.printKVSeparator();
            if (quotaAllowed != -1L) {
                System.out.println(FileUtils.byteCountToDisplaySize((long)(quotaAllowed - quotaUsed)));
            } else {
                System.out.println("Unknown");
            }
        }
        NSSummaryCLIUtils.printNewLines(1);
        return null;
    }
}

