/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.h2;

import java.sql.SQLException;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.h2.information_schema.tables.FunctionColumns;
import org.jooq.tools.StringUtils;
import org.jooq.util.h2.H2DataType;

public class H2RoutineDefinition
extends AbstractRoutineDefinition {
    public H2RoutineDefinition(SchemaDefinition schema, String name, String comment, String typeName, Number precision, Number scale) {
        super(schema, null, name, comment, null);
        if (!StringUtils.isBlank((String)typeName)) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, typeName, precision, precision, scale, null, (String)null);
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
    }

    @Override
    protected void init0() throws SQLException {
        for (Record record : this.create().select(FunctionColumns.COLUMN_NAME, FunctionColumns.TYPE_NAME, FunctionColumns.PRECISION, FunctionColumns.SCALE, FunctionColumns.POS, FunctionColumns.NULLABLE, FunctionColumns.COLUMN_DEFAULT).from((TableLike)FunctionColumns.FUNCTION_COLUMNS).where(FunctionColumns.ALIAS_SCHEMA.equal((Object)this.getSchema().getName())).and(FunctionColumns.ALIAS_NAME.equal((Object)this.getName())).and(FunctionColumns.POS.gt((Object)0)).orderBy((OrderField)FunctionColumns.POS.asc()).fetch()) {
            String paramName = (String)record.get(FunctionColumns.COLUMN_NAME);
            String typeName = (String)record.get(FunctionColumns.TYPE_NAME);
            Integer precision = (Integer)record.get(FunctionColumns.PRECISION);
            Short scale = (Short)record.get(FunctionColumns.SCALE);
            int position = (Integer)record.get(FunctionColumns.POS);
            boolean nullable = (Boolean)record.get(FunctionColumns.NULLABLE, Boolean.TYPE);
            String defaultValue = (String)record.get(FunctionColumns.COLUMN_DEFAULT);
            if (position == 0 && H2DataType.OTHER.getTypeName().equalsIgnoreCase(typeName)) continue;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), typeName, (Number)precision, (Number)precision, (Number)scale, (Boolean)nullable, defaultValue);
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, paramName, position, type);
            this.addParameter(InOutDefinition.IN, parameter);
        }
    }
}

