/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.ratis.datastream.impl.DataStreamPacketImpl;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;

public class DataStreamRequestByteBuf
extends DataStreamPacketImpl
implements DataStreamRequest {
    private final ByteBuf buf;
    private final WriteOption[] options;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public DataStreamRequestByteBuf(ClientId clientId, RaftProtos.DataStreamPacketHeaderProto.Type type, long streamId, long streamOffset, WriteOption[] options, ByteBuf buf) {
        super(clientId, type, streamId, streamOffset);
        this.buf = buf != null ? buf.asReadOnly() : Unpooled.EMPTY_BUFFER;
        this.options = options;
    }

    public DataStreamRequestByteBuf(DataStreamRequestHeader header, ByteBuf buf) {
        this(header.getClientId(), header.getType(), header.getStreamId(), header.getStreamOffset(), header.getWriteOptions(), buf);
    }

    public long getDataLength() {
        return this.buf.readableBytes();
    }

    public ByteBuf slice() {
        return this.buf.slice();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public WriteOption[] getWriteOptions() {
        return this.options;
    }
}

