/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.io.IOException;
import java.time.Instant;
import java.util.Set;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenSecretManager;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OzoneBlockTokenSecretManager
extends ShortLivedTokenSecretManager<OzoneBlockTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneBlockTokenSecretManager.class);

    public OzoneBlockTokenSecretManager(SecurityConfig conf, long tokenLifetime, String omCertSerialId) {
        super(conf, tokenLifetime, omCertSerialId, LOG);
    }

    public OzoneBlockTokenIdentifier createIdentifier() {
        throw new SecurityException("Ozone block token can't be created without owner and access mode information.");
    }

    public OzoneBlockTokenIdentifier createIdentifier(String owner, BlockID blockID, Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) {
        return new OzoneBlockTokenIdentifier(owner, blockID, modes, this.getTokenExpiryTime().toEpochMilli(), this.getCertSerialId(), maxLength);
    }

    public Token<OzoneBlockTokenIdentifier> generateToken(String user, BlockID blockId, Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) {
        OzoneBlockTokenIdentifier tokenIdentifier = this.createIdentifier(user, blockId, modes, maxLength);
        if (LOG.isDebugEnabled()) {
            long expiryTime = tokenIdentifier.getExpiryDate();
            LOG.info("Issued delegation token -> expiryTime:{}, tokenId:{}", (Object)Instant.ofEpochMilli(expiryTime), (Object)tokenIdentifier);
        }
        return new Token(tokenIdentifier.getBytes(), this.createPassword((TokenIdentifier)tokenIdentifier), tokenIdentifier.getKind(), new Text(tokenIdentifier.getService()));
    }

    public Token<OzoneBlockTokenIdentifier> generateToken(BlockID blockId, Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long maxLength) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String userID = ugi == null ? null : ugi.getShortUserName();
        return this.generateToken(userID, blockId, modes, maxLength);
    }

    public byte[] retrievePassword(OzoneBlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        this.validateToken(identifier);
        return this.createPassword((TokenIdentifier)identifier);
    }

    public long renewToken(Token<OzoneBlockTokenIdentifier> token, String renewer) {
        throw new UnsupportedOperationException("Renew token operation is not supported for ozone block tokens.");
    }

    public OzoneBlockTokenIdentifier cancelToken(Token<OzoneBlockTokenIdentifier> token, String canceller) {
        throw new UnsupportedOperationException("Cancel token operation is not supported for ozone block tokens.");
    }

    public boolean validateToken(OzoneBlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        long now = Time.now();
        if (identifier.getExpiryDate() < now) {
            throw new SecretManager.InvalidToken("token " + this.formatTokenId((TokenIdentifier)identifier) + " is " + "expired, current time: " + Time.formatTime((long)now) + " expiry time: " + identifier.getExpiryDate());
        }
        if (!this.verifySignature(identifier, this.createPassword((TokenIdentifier)identifier))) {
            throw new SecretManager.InvalidToken("Tampered/Invalid token.");
        }
        return true;
    }

    public boolean verifySignature(OzoneBlockTokenIdentifier identifier, byte[] password) {
        throw new UnsupportedOperationException("This operation is not supported for block tokens.");
    }
}

