/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.protocolPB.OMInterServiceProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerInterServiceProtocolProtos;

public class OMInterServiceProtocolServerSideImpl
implements OMInterServiceProtocolPB {
    private final OzoneManagerRatisServer omRatisServer;
    private final boolean isRatisEnabled;

    public OMInterServiceProtocolServerSideImpl(OzoneManagerRatisServer ratisServer, boolean enableRatis) {
        this.omRatisServer = ratisServer;
        this.isRatisEnabled = enableRatis;
    }

    public OzoneManagerInterServiceProtocolProtos.BootstrapOMResponse bootstrap(RpcController controller, OzoneManagerInterServiceProtocolProtos.BootstrapOMRequest request) throws ServiceException {
        if (request == null) {
            return null;
        }
        if (!this.isRatisEnabled) {
            return OzoneManagerInterServiceProtocolProtos.BootstrapOMResponse.newBuilder().setSuccess(false).setErrorCode(OzoneManagerInterServiceProtocolProtos.ErrorCode.RATIS_NOT_ENABLED).setErrorMsg("New OM node cannot be bootstrapped as Ratis is not enabled on existing OM").build();
        }
        this.checkLeaderStatus();
        OMNodeDetails newOmNode = new OMNodeDetails.Builder().setOMNodeId(request.getNodeId()).setHostAddress(request.getHostAddress()).setRatisPort(request.getRatisPort()).build();
        try {
            this.omRatisServer.addOMToRatisRing(newOmNode);
        }
        catch (IOException ex) {
            return OzoneManagerInterServiceProtocolProtos.BootstrapOMResponse.newBuilder().setSuccess(false).setErrorCode(OzoneManagerInterServiceProtocolProtos.ErrorCode.RATIS_BOOTSTRAP_ERROR).setErrorMsg(ex.getMessage()).build();
        }
        return OzoneManagerInterServiceProtocolProtos.BootstrapOMResponse.newBuilder().setSuccess(true).build();
    }

    private void checkLeaderStatus() throws ServiceException {
        OzoneManagerRatisUtils.checkLeaderStatus(this.omRatisServer.checkLeaderStatus(), this.omRatisServer.getRaftPeerId());
    }
}

